/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LinkedHashMapSerializer
extends Serializer<LinkedHashMap> {
    public void write(Kryo kryo, Output output, LinkedHashMap map) {
        Set entrySet = map.entrySet();
        List entryList = entrySet.stream().map(this::adaptEntry).collect(Collectors.toList());
        kryo.writeObject(output, entryList);
    }

    private Map.Entry<?, ?> adaptEntry(Map.Entry<?, ?> original) {
        return new AbstractMap.SimpleEntry(original.getKey(), original.getValue());
    }

    public LinkedHashMap read(Kryo kryo, Input input, Class<LinkedHashMap> aClass) {
        LinkedHashMap mapWrapper = new LinkedHashMap();
        Collection entries = (Collection)kryo.readObject(input, ArrayList.class);
        for (Map.Entry entry : entries) {
            mapWrapper.put(entry.getKey(), entry.getValue());
        }
        return mapWrapper;
    }
}

