/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.newproject;

import com.google.common.util.concurrent.FutureCallback;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.wizards.NewJavaWizardPageTwo;
import org.mule.tooling.ui.wizards.newproject.CreateNewMuleProjectRunnable;
import org.mule.tooling.ui.wizards.newproject.IMuleNewProjectPage;
import org.mule.tooling.ui.wizards.newproject.MuleNewProjectPage;
import org.mule.tooling.ui.wizards.newproject.NewJavaWizardPageOne;
import org.mule.tooling.utils.SyncFutureCallback;

public class MuleNewProjectWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private NewJavaProjectWizardPageOne firstJavaProjectWizardPage;
    private NewJavaProjectWizardPageTwo secondJavaProjectWizardPage;
    private boolean alreadyFinishing = false;
    private IMuleNewProjectPage newMuleProjectPage;

    public void addPages() {
        this.setWindowTitle(this.getTitle());
        this.newMuleProjectPage = this.createNewMuleProjectPage();
        this.addPage(this.getNewMuleProjectPage());
        this.firstJavaProjectWizardPage = this.createNewJavaProjectWizardPageOne();
        this.addPage((IWizardPage)this.getFirstJavaProjectWizardPage());
        this.secondJavaProjectWizardPage = this.createNewJavaProjectWizardPageTwo();
        this.addPage((IWizardPage)this.getSecondJavaProjectWizardPage());
    }

    protected NewJavaProjectWizardPageTwo createNewJavaProjectWizardPageTwo() {
        return new NewJavaWizardPageTwo(this.getFirstJavaProjectWizardPage());
    }

    protected NewJavaProjectWizardPageOne createNewJavaProjectWizardPageOne() {
        return new NewJavaWizardPageOne(this.getNewMuleProjectPage());
    }

    protected String getTitle() {
        return "New Mule Project";
    }

    protected IMuleNewProjectPage createNewMuleProjectPage() {
        try {
            return new MuleNewProjectPage();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was an error loading the extensions for the New Mule Project wizard", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void updateCustomDataInJavaProject(String appName) {
        String projectName = CoreUtils.getJavaFriendlyProjectName((String)appName);
        this.getFirstJavaProjectWizardPage().setProjectName(projectName);
        this.getFirstJavaProjectWizardPage().setProjectLocationURI(this.getNewMuleProjectPage().getProjectLocation());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.getNewMuleProjectPage()) {
            this.updateCustomDataInJavaProject(this.getNewMuleProjectPage().getProjectName());
        }
        return super.getNextPage(page);
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    public boolean performFinish() {
        block3: {
            try {
                this.setAlreadyFinishing(true);
                this.updateCustomDataInJavaProject(this.getNewMuleProjectPage().getProjectName());
                this.doPerformFinish();
                this.setAlreadyFinishing(false);
            }
            catch (InvocationTargetException e) {
                MuleUIPlugin.getDefault().logError("Unable to create project.", e);
            }
            catch (InterruptedException interruptedException) {
                if (this.getWorkbench().getActiveWorkbenchWindow() == null) break block3;
                MessageDialog.openInformation((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Interrupted", (String)"Project creation interrupted");
            }
        }
        return true;
    }

    protected void doPerformFinish() throws InvocationTargetException, InterruptedException {
        SyncFutureCallback callback = new SyncFutureCallback();
        CreateNewMuleProjectRunnable runnable = new CreateNewMuleProjectRunnable(this.getNewMuleProjectPage(), this.getFirstJavaProjectWizardPage(), this.getSecondJavaProjectWizardPage(), (FutureCallback<IMuleProject>)callback);
        this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
        callback.syncGetResult();
    }

    private void setAlreadyFinishing(boolean finishing) {
        this.alreadyFinishing = finishing;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setNeedsProgressMonitor(true);
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public boolean canFinish() {
        if (this.alreadyFinishing) {
            return false;
        }
        if (this.getNewMuleProjectPage().isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    protected NewJavaProjectWizardPageOne getFirstJavaProjectWizardPage() {
        return this.firstJavaProjectWizardPage;
    }

    protected NewJavaProjectWizardPageTwo getSecondJavaProjectWizardPage() {
        return this.secondJavaProjectWizardPage;
    }

    protected IMuleNewProjectPage getNewMuleProjectPage() {
        return this.newMuleProjectPage;
    }
}

