/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.newproject;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.impl.model.DefaultInitializationData;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.DependencyToAssetCache;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.ui.common.LocationComponent;
import org.mule.tooling.ui.common.ProjectNameInputComponent;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.wizards.extensible.ExtensibleWizardPage;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.newproject.IMuleNewProjectPage;

public class MuleNewProjectPage
extends ExtensibleWizardPage
implements IMuleNewProjectPage {
    private static final String INCOMPATIBILITY_MESSAGE = "Async APIs are compatible with Mule Runtime 4.6 and later.";
    private static final String NEW_MULE_PROJECT_PAGE_CSS_ID = "org-mule-tooling-ui-MuleNewProjectPage";
    public static final String KEY_RUNNABLE_CONTEXT = "runnableContext";
    public static final String PAGE_TITLE = "Project Settings";
    public static final String PAGE_DESCRIPTION = "Create a Mule project in the workspace or in an external location.";
    public static final String KEY_MULE_PROJECT = "muleProject";
    public static final String PAGE_ID = "org.mule.tooling.ui.mulenewproject";
    private static final String PAGE_NAME = "muleNewProjectWizardPage";
    private static final String KEY_API_DEPENDENCIES = "ApiDependencies";
    private LocationComponent extensionLocation;
    private Long startEventProcessing;
    private ProjectNameInputComponent projectNameExtension;
    @WizardContext(alias="serverDefinition")
    private IServerDefinition selectedServer;
    @WizardContext(alias="ApiDependencies")
    private Set<IDependency> apiDependencies = new HashSet<IDependency>();
    @WizardContext
    private String projectName;

    public MuleProjectKind<IMuleApplicationProject> getProjectKind() {
        return MuleProjectKind.APPLICATION;
    }

    public MuleNewProjectPage(String pageTitle, String pageDescription) throws CoreException {
        super(PAGE_NAME, PAGE_ID, pageTitle, pageDescription);
    }

    public MuleNewProjectPage() throws CoreException {
        this(PAGE_TITLE, PAGE_DESCRIPTION);
    }

    @Override
    public void createControl(Composite parent) {
        this.inject(KEY_RUNNABLE_CONTEXT, this.getWizard().getContainer());
        super.createControl(parent);
        ThemeUtils.setCssId((Object)this.getShell(), (String)NEW_MULE_PROJECT_PAGE_CSS_ID);
    }

    @Override
    protected List<ExtensibleWizardPage.WizardExtensionHolder> getWizardExtensionHolders() throws CoreException {
        this.startEventProcessing = System.currentTimeMillis();
        ArrayList<ExtensibleWizardPage.WizardExtensionHolder> extensionHolders = new ArrayList<ExtensibleWizardPage.WizardExtensionHolder>();
        this.projectNameExtension = new ProjectNameInputComponent();
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, this.projectNameExtension, PAGE_ID, 5));
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, new ServerChooserComponent(), PAGE_ID, 7));
        this.extensionLocation = new LocationComponent(Display.getCurrent().getActiveShell(), this.projectNameExtension);
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, this.extensionLocation, PAGE_ID, 20));
        extensionHolders.addAll(super.getWizardExtensionHolders());
        return extensionHolders;
    }

    @Override
    public String getProjectName() {
        return this.projectName == null ? "" : this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setSelectedServer(IServerDefinition selectedServer) {
        this.selectedServer = selectedServer;
    }

    @Override
    public IServerDefinition getSelectedServer() {
        return this.selectedServer;
    }

    @Override
    public String getSelectedRuntimeId() {
        return this.selectedServer.getId();
    }

    @Override
    public Set<IDependency> getApiDependencies() {
        return this.apiDependencies;
    }

    public void setApiDependencies(Set<IDependency> apiDependencies) {
        this.apiDependencies = apiDependencies;
    }

    @Override
    public void performFinish(final IProgressMonitor monitor, final IMuleProject muleProject) {
        this.inject(KEY_MULE_PROJECT, muleProject);
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MuleNewProjectPage.super.performFinish(monitor);
                this.sendMetrics(muleProject);
                return null;
            }

            private void sendMetrics(IMuleProject muleProject2) {
                AuthUser currentUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
                Optional jreVersion = VMUtils.getJreVersion((IJavaProject)muleProject2.getJavaProject());
                long endEventProcessing = System.currentTimeMillis();
                long duration = endEventProcessing - MuleNewProjectPage.this.startEventProcessing;
                ArrayList dependencies = new ArrayList();
                dependencies.addAll(MuleNewProjectPage.this.apiDependencies.stream().map(IDependency::getDependency).collect(Collectors.toList()));
                dependencies.stream().forEach(dep -> this.sendReport(muleProject2, (MavenDependency)dep, currentUser, jreVersion, duration));
            }

            private void sendReport(IMuleProject muleProject2, MavenDependency dep, AuthUser currentUser, Optional<String> jreVersion, Long duration) {
                try {
                    Optional asset = ((DependencyToAssetCache.GraphServiceCallResult)DependencyToAssetCache.instance().getAssetFrom(dep).get()).getExchangeAsset();
                    AnalyticsRecordsFactory.single((String)"IMPLEMENTATION_PROJECT_CREATED", (IMuleProject)muleProject2).withDependencyProperty(Arrays.asList(dep)).addMetadata("SpecificationSource", "MuleSoft VCS").addMetadata("rootOrgId", currentUser != null ? currentUser.getOrganization().getId() : "").addMetadata("rootOrgName", currentUser != null ? currentUser.getOrganization().getName() : "").addMetadata("apiType", asset.isPresent() ? ((ExchangeAsset)asset.get()).getType() : "").addMetadata("apiLanguage", DependencyUtils.getValueInAssetAttributes(asset, "original-format")).addMetadata("apiLanguageVersion", DependencyUtils.getValueInAssetAttributes(asset, "original-format-version")).addMetadata("jdkVersion", jreVersion.orElse("")).addMetadata("apiFirstTimeScaffold", "true").addMetadata("apiDurationScaffolded", duration.toString()).track();
                }
                catch (InterruptedException | ExecutionException e) {
                    MuleCorePlugin.logError((String)"Error sending the metric IMPLEMENTATION_PROJECT_CREATED", (Throwable)e);
                }
            }
        }, (IMuleProject)muleProject);
    }

    @Override
    public IMuleProject createMuleProject(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        return MuleRuntime.createMuleProject((IJavaProject)javaProject, (ProjectInitializationData)DefaultInitializationData.create().setName(this.getProjectName()).setDescription("").setRuntimeId(this.getSelectedRuntimeId()));
    }

    @Override
    public URI getProjectLocation() {
        File file = new File(this.extensionLocation.getLocation().toOSString());
        return file.toURI();
    }

    public boolean isPageComplete() {
        if (this.projectNameExtension.isInErroneousState() || this.extensionLocation.isInErroneousState()) {
            return false;
        }
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(this.apiDependencies.stream().map(IDependency::getDependency).collect(Collectors.toList()));
        if (CoreUtils.isRuntimeCompatibleWithAsyncAPI(dependencies, (IServerDefinition)this.selectedServer)) {
            this.setMessage(PAGE_DESCRIPTION, 0);
            return true;
        }
        this.setMessage(INCOMPATIBILITY_MESSAGE, 3);
        return false;
    }
}

