/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.newproject;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.impl.model.DefaultInitializationData;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.LocationComponent;
import org.mule.tooling.ui.common.ProjectNameInputComponent;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.wizards.extensible.ExtensibleWizardPage;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.newproject.IMuleNewProjectPage;

public class MuleNewDomainPage
extends ExtensibleWizardPage
implements IMuleNewProjectPage {
    public static final String PAGE_TITLE = "Domain Project Settings";
    public static final String PAGE_DESCRIPTION = "Create a Mule Domain project in the workspace or in an external location.";
    public static final String KEY_MULE_PROJECT = "muleProject";
    public static final String PAGE_ID = "org.mule.tooling.ui.mulenewdomain";
    private static final String PAGE_NAME = "muleNewDomainWizardPage";
    @WizardContext(alias="serverDefinition")
    private IServerDefinition selectedServer;
    @WizardContext
    private String projectName;
    @WizardContext
    private String domainName;
    private LocationComponent extensionLocation;

    public MuleProjectKind<IMuleDomainProject> getProjectKind() {
        return MuleProjectKind.DOMAIN;
    }

    public MuleNewDomainPage(String pageTitle, String pageDescription) throws CoreException {
        super(PAGE_NAME, PAGE_ID, pageTitle, pageDescription);
    }

    public MuleNewDomainPage() throws CoreException {
        this(PAGE_TITLE, PAGE_DESCRIPTION);
    }

    @Override
    protected List<ExtensibleWizardPage.WizardExtensionHolder> getWizardExtensionHolders() throws CoreException {
        ArrayList<ExtensibleWizardPage.WizardExtensionHolder> extensionHolders = new ArrayList<ExtensibleWizardPage.WizardExtensionHolder>();
        ProjectNameInputComponent projectInputComponent = new ProjectNameInputComponent();
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, projectInputComponent, PAGE_ID, 5));
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, new ServerChooserComponent(CoreUtils.getDomainsCapableServers()), PAGE_ID, 7));
        this.extensionLocation = new LocationComponent(Display.getCurrent().getActiveShell(), projectInputComponent);
        extensionHolders.add(new ExtensibleWizardPage.WizardExtensionHolder(this, this.extensionLocation, PAGE_ID, 20));
        extensionHolders.addAll(super.getWizardExtensionHolders());
        return extensionHolders;
    }

    @Override
    public String getProjectName() {
        return this.projectName == null ? "" : this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setSelectedServer(IServerDefinition selectedServer) {
        this.selectedServer = selectedServer;
    }

    @Override
    public IServerDefinition getSelectedServer() {
        return this.selectedServer;
    }

    @Override
    public String getSelectedRuntimeId() {
        return this.selectedServer.getId();
    }

    @Override
    public void performFinish(final IProgressMonitor monitor, IMuleProject muleProject) {
        this.inject(KEY_MULE_PROJECT, muleProject);
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MuleNewDomainPage.super.performFinish(monitor);
                return null;
            }
        }, (IMuleProject)muleProject);
    }

    @Override
    public IMuleProject createMuleProject(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        return MuleRuntime.createMuleProject((IJavaProject)javaProject, (ProjectInitializationData)DefaultInitializationData.create().setName(this.getProjectName()).setDomainName(this.getDomainName()).setRuntimeId(this.getSelectedRuntimeId()));
    }

    @Override
    public URI getProjectLocation() {
        File file = new File(this.extensionLocation.getLocation().toOSString());
        return file.toURI();
    }

    @Override
    public Set<IDependency> getApiDependencies() {
        return new HashSet<IDependency>();
    }
}

