/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.newproject;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class DomainNameInputComponent
implements WizardPagePartExtension,
ModifyListener {
    public static final String KEY_DOMAIN_NAME = "domainName";
    @WizardContext
    private PartStatusHandler statusHandler = new NaiveStatusHandler();
    @WizardContext
    private String domainName;
    @WizardContext
    private String projectName;
    @WizardContext
    private IServerDefinition serverDefinition;
    private Text domainIdText;

    @Override
    public Control createControl(Composite parent) {
        Group group = UiUtils.createGroupWithTitle(parent, "Domain Settings", 2);
        Label label = new Label((Composite)group, 0);
        label.setText("Domain name: ");
        GridDataFactory.fillDefaults().hint(100, -1).applyTo((Control)label);
        this.domainIdText = new Text((Composite)group, 2048);
        this.domainIdText.addModifyListener((ModifyListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainIdText);
        return group;
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    public void setServerDefinition(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.validate();
    }

    public PartStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainId) {
        this.domainName = domainId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.domainIdText.setText(projectName.replaceAll("\\s", "_"));
    }

    public void modifyText(ModifyEvent e) {
        this.domainName = this.domainIdText.getText();
        this.statusHandler.notifyUpdate(this, KEY_DOMAIN_NAME, this.domainName);
        this.validate();
    }

    private void validate() {
        if (StringUtils.isNotBlank((String)this.domainName)) {
            if (MuleResourceUtils.isValidDomainName((String)this.domainName)) {
                if (!this.getDomainProject(this.domainName, this.serverDefinition).isPresent()) {
                    this.statusHandler.clearErrors(this);
                    this.statusHandler.setPartComplete(this, true);
                } else {
                    this.statusHandler.setErrorMessage(this, "A project with the domain name '" + this.domainName + "' and same runtime version already exists");
                    this.statusHandler.setPartComplete(this, false);
                }
            } else {
                this.statusHandler.setErrorMessage(this, "'" + this.domainName + "' is not a valid domain name");
                this.statusHandler.setPartComplete(this, false);
            }
        } else {
            this.statusHandler.setErrorMessage(this, "Domain name cannot be empty");
            this.statusHandler.setPartComplete(this, false);
        }
    }

    private Optional<IMuleDomainProject> getDomainProject(String domainId, IServerDefinition serverDefinition) {
        List<IMuleDomainProject> domainProjects;
        try {
            domainProjects = MuleRuntime.getMuleProjects((MuleProjectKind)MuleProjectKind.DOMAIN);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem trying to collect all available domain projects", (Throwable)e);
            domainProjects = Collections.emptyList();
        }
        IMuleDomainProject found = null;
        for (IMuleDomainProject project : domainProjects) {
            if (!project.getServerDefinition().equals(serverDefinition) || !project.getDomainName().equals(domainId)) continue;
            found = project;
            break;
        }
        return Optional.fromNullable(found);
    }
}

