/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.newproject;

import com.google.common.util.concurrent.FutureCallback;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.deployer.MuleApplicationDeployment;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IAPIDefinitionPartEventListener;
import org.mule.tooling.core.event.IMuleProjectCreatedEventListener;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.packageManager.PostImportActionsJob;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.Log4jConfigurationExtension;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.newproject.IMuleNewProjectPage;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class CreateNewMuleProjectRunnable
implements IRunnableWithProgress {
    private final String applicationName;
    private final IWorkingSet[] workingSets;
    private final NewJavaProjectWizardPageTwo secondJavaProjectWizardPage;
    private final IMuleNewProjectPage newMuleProjectPage;
    private FutureCallback<IMuleProject> callback;

    public CreateNewMuleProjectRunnable(IMuleNewProjectPage newMuleProjectPage, NewJavaProjectWizardPageOne firstJavaProjectWizardPage, NewJavaProjectWizardPageTwo secondJavaProjectWizardPage, FutureCallback<IMuleProject> callback) {
        this.newMuleProjectPage = newMuleProjectPage;
        this.secondJavaProjectWizardPage = secondJavaProjectWizardPage;
        this.applicationName = newMuleProjectPage.getProjectName();
        this.workingSets = firstJavaProjectWizardPage.getWorkingSets();
        this.callback = callback;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            ResourcesPlugin.getWorkspace().run(this.getAction(), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IWorkspaceRunnable getAction() {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CreateNewMuleProjectRunnable.this.runInWorkspace(monitor);
            }
        };
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Setting up Mule project", (int)100);
        subMonitor.worked(10);
        try {
            final MuleProjectKind<?> projectKind = this.newMuleProjectPage.getProjectKind();
            IMuleProject muleProject = (IMuleProject)MuleRuntime.runLockingProjectsRegistry((Callable)new Callable<IMuleProject>(){

                @Override
                public IMuleProject call() throws Exception {
                    CreateNewMuleProjectRunnable.this.secondJavaProjectWizardPage.performFinish((IProgressMonitor)subMonitor.split(40));
                    IJavaProject javaProject = CreateNewMuleProjectRunnable.this.secondJavaProjectWizardPage.getJavaProject();
                    CreateNewMuleProjectRunnable.this.configureWorkingSets(javaProject, CreateNewMuleProjectRunnable.this.workingSets);
                    IServerDefinition selectedRuntime = MuleCorePlugin.getServerManager().getServerDefinition(CreateNewMuleProjectRunnable.this.newMuleProjectPage.getSelectedRuntimeId());
                    CreateNewMuleProjectRunnable.this.createPomFile(javaProject, projectKind, selectedRuntime);
                    if (MuleProjectKind.APPLICATION.equals(projectKind)) {
                        MuleRuntime.addMuleNature((IProject)javaProject.getProject());
                    } else if (MuleProjectKind.DOMAIN.equals(projectKind)) {
                        MuleRuntime.initializeMuleAndDomainNature((IProject)javaProject.getProject());
                        AnalyticsRecordsFactory.single((String)Events.CREATE_DOMAIN_PROJECT).track();
                    }
                    return CreateNewMuleProjectRunnable.this.newMuleProjectPage.createMuleProject(CreateNewMuleProjectRunnable.this.secondJavaProjectWizardPage.getJavaProject(), (IProgressMonitor)subMonitor.split(30));
                }
            }, (String)this.applicationName);
            MuleRuntime.configureMuleProjectClasspath((IMuleProject)muleProject, (IServerDefinition)this.newMuleProjectPage.getSelectedServer());
            if (projectKind.equals((Object)MuleProjectKind.APPLICATION)) {
                this.createLog4jConfigFiles((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject));
            }
            this.notifyProjectCreated(muleProject);
            this.performFinishOnExtensiblePage((IProgressMonitor)subMonitor.split(20), muleProject);
            this.createAndShowConfiguration(muleProject);
            this.notifyProjectOpen(muleProject);
            PostImportActionsJob.schedule((IMuleProject)muleProject);
            this.callback.onSuccess((Object)muleProject);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException e) {
            this.handle(e);
            this.callback.onFailure((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (InterruptedException e) {
            this.handle(e, MuleCorePlugin.createStatus((int)4, (String)"Project creation interrupted", (Throwable)e));
            this.callback.onFailure((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Throwable e) {
            this.callback.onFailure(e);
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.ui", "Unexpected error creating a new mule project", e));
        }
        finally {
            subMonitor.done();
        }
    }

    protected String getArtifactIdFromProjectName(String applicationName) {
        return applicationName.replace(' ', '-').toLowerCase();
    }

    protected void createPomFile(IJavaProject javaProject, MuleProjectKind<?> muleProjectKind, IServerDefinition selectedRuntime) throws CoreException {
        String defaultGroupId = "com.mycompany";
        String defaultVersion = "1.0.0-SNAPSHOT";
        MavenDependency mavenModel = MavenModelHelper.mavenDependency((String[])new String[]{defaultGroupId, this.getArtifactIdFromProjectName(this.applicationName), defaultVersion});
        MavenResourceUtils.createPomFile(muleProjectKind, (IJavaProject)javaProject, (IServerDefinition)selectedRuntime, (MavenDependency)mavenModel);
    }

    private void createLog4jConfigFiles(IMuleApplicationProject muleProject) throws CoreException {
        Optional log4jConfiguration = Log4jConfigurationExtension.getLog4jConfiguration((IServerDefinition)muleProject.getServerDefinition());
        if (log4jConfiguration.isPresent()) {
            this.doCreateLog4jConfigFiles(muleProject, (Log4jConfigurationExtension)log4jConfiguration.get());
        }
    }

    private void doCreateLog4jConfigFiles(IMuleApplicationProject muleProject, Log4jConfigurationExtension log4jConfiguration) throws CoreException {
        IProject project = muleProject.getProject();
        MuleResourceUtils.createFile((IProject)project, (IFolder)muleProject.getMuleResourcesFolder(), (String)this.getReplacedContents(log4jConfiguration.getMainFile(), (IMuleProject)muleProject), (String)log4jConfiguration.getMainFileName());
        MuleResourceUtils.createFile((IProject)project, (IFolder)muleProject.getMuleTestResourcesFolder(), (String)this.getReplacedContents(log4jConfiguration.getTestFile(), (IMuleProject)muleProject), (String)log4jConfiguration.getTestFileName());
    }

    private String getReplacedContents(URL url, IMuleProject muleProject) {
        String replacedContents = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream stream = url.openStream();){
                String contents = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                replacedContents = contents.replace("APPLICATIONNAME", muleProject.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"There was a problem generating default log4j files", (Throwable)e);
        }
        return replacedContents;
    }

    private void handle(CoreException e) {
        this.handle((Exception)((Object)e), e.getStatus());
    }

    private void handle(Exception e, IStatus status) {
        MuleCorePlugin.logError((String)("Error creating project: " + this.applicationName), (Throwable)e);
        Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        display.asyncExec(() -> {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell parent = activeWorkbenchWindow == null ? null : activeWorkbenchWindow.getShell();
            ErrorDialog.openError((Shell)parent, (String)"Error", (String)("Unable to create project: " + this.applicationName), (IStatus)status);
        });
    }

    private void notifyProjectCreated(final IMuleProject muleProject) {
        AnalyticsRecordsFactory.single((String)Events.MULE_PROJECT_CREATED, (IMuleProject)muleProject).track();
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new IEvent<IMuleProjectCreatedEventListener>(){

            public EventType<IMuleProjectCreatedEventListener> getAssociatedType() {
                return CoreEventTypes.ON_MULE_PROJECT_CREATED_EVENT;
            }

            public void dispatch(IMuleProjectCreatedEventListener handler) {
                handler.onProjectCreated(muleProject);
            }
        });
    }

    private void notifyProjectOpen(final IMuleProject muleProject) {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        eventBus.fireEvent((IEvent)new IEvent<IMuleProjectEventListener>(){

            public EventType<IMuleProjectEventListener> getAssociatedType() {
                return CoreEventTypes.ON_MULE_PROJECT_EVENT;
            }

            public void dispatch(IMuleProjectEventListener handler) {
                handler.onMuleProjectOpened(muleProject.getProject());
            }
        });
    }

    private void createAndShowConfiguration(final IMuleProject muleProject) {
        final Runnable configurationTask = () -> {
            try {
                this.doCreateAndShowConfiguration(muleProject);
                this.scheduleUpdateDeployPropertiesJob(muleProject);
            }
            catch (IOException | CoreException e) {
                MuleCorePlugin.logError((String)"There was a problem trying to open the editor for the new project", (Throwable)e);
            }
        };
        if (this.newMuleProjectPage.getApiDependencies().isEmpty()) {
            Display.getDefault().asyncExec(configurationTask);
        } else {
            IAPIDefinitionPartEventListener listener = new IAPIDefinitionPartEventListener(){

                public void onAPIDefinitionPartFinished(IMuleProject project) {
                    if (project.equals(muleProject)) {
                        Display.getDefault().asyncExec(configurationTask);
                    }
                }
            };
            MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ON_API_DEFINITION_PART_SCAFFOLD_RESOLVED, (IEventHandler)listener);
        }
    }

    protected void scheduleUpdateDeployPropertiesJob(final IMuleProject muleProject) {
        Job updateDeployPropsJob = new Job("Update mule-artifact.json file"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean success = MuleApplicationDeployment.updateDeploymentDescriptor((IMuleProject)muleProject);
                return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        updateDeployPropsJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        updateDeployPropsJob.schedule();
    }

    protected void doCreateAndShowConfiguration(IMuleProject muleProject) throws CoreException, IOException {
        IFile configuration;
        if (!muleProject.getProject().isAccessible()) {
            return;
        }
        List<IResource> configs = this.getConfigFiles(muleProject.getMuleAppsFolder());
        if (configs.isEmpty()) {
            configuration = CoreUtils.createEmptyXmlConfiguration((IMuleProject)muleProject);
        } else {
            Optional<IFile> map = configs.stream().findFirst().map(r -> (IFile)r.getAdapter(IFile.class));
            configuration = map.get();
        }
        UiUtils.openEditorForFile(configuration);
    }

    protected List<IResource> getConfigFiles(IFolder muleAppsFolder) {
        File muleAppsFolderfile = muleAppsFolder.getLocation().toFile();
        File[] configFiles = muleAppsFolderfile.listFiles(new MuleConfigurationFileFilter());
        if (configFiles == null || configFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IResource> configResources = new ArrayList<IResource>(configFiles.length);
        File[] fileArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IFile resourceFromFile = CoreUtils.getResourceFromFile((File)file);
            if (resourceFromFile != null) {
                configResources.add((IResource)resourceFromFile);
            }
            ++n2;
        }
        return configResources;
    }

    private void performFinishOnExtensiblePage(IProgressMonitor monitor, IMuleProject muleProject) {
        if (this.newMuleProjectPage != null) {
            this.newMuleProjectPage.performFinish(monitor, muleProject);
        }
    }

    private void configureWorkingSets(IJavaProject javaProject, IWorkingSet[] workingSets) {
        if (workingSets.length > 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)javaProject, workingSets);
        }
    }

    private final class MuleConfigurationFileFilter
    implements FilenameFilter {
        private MuleConfigurationFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

