/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.extensible;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.wizards.extensible.ExtensiblePartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartStatusListener;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public abstract class ExtensibleWizardPage
extends WizardPage
implements WizardPagePartStatusListener {
    private static final String CHILDREN_TARGET_WIZARD = "targetWizardPage";
    private static final String ATTRIBUTE_TARGET_WIZARD_ID = "id";
    private static final int DEFAULT_START_LEVEL = 10;
    private static final String ATTRIBUTE_LEVEL = "level";
    public static final String EXTENSION_POINT_ID_WIZARD_PAGE_PARTS = "org.mule.tooling.ui.wizardpagepart";
    private static final int TOTAL_WORK = 100;
    private static final int DIALOG_NEW_PROJECT_WIDTH = 850;
    private static final int DIALOG_NEW_PROJECT_HEIGHT = 800;
    private static final int DIALOG_NEW_PROJECT_HEIGHT_COLLAPSED = 550;
    private List<WizardPagePartExtension> extensions = new ArrayList<WizardPagePartExtension>();
    private Map<WizardPagePartExtension, String> partsAndErrors = new HashMap<WizardPagePartExtension, String>();
    private Map<WizardPagePartExtension, Boolean> partsCompleteMap;

    public ExtensibleWizardPage(String pageName, String extensiblePageId, String pageTitle, String pageDescription) throws CoreException {
        super(pageName);
        this.loadWizardPagePartExtensions(extensiblePageId);
        this.initializePartsCompleteMap();
        this.setTitle(pageTitle);
        if (pageDescription != null) {
            this.setDescription(pageDescription);
        }
    }

    private void initializePartsCompleteMap() {
        this.partsCompleteMap = new HashMap<WizardPagePartExtension, Boolean>();
        for (WizardPagePartExtension extension : this.extensions) {
            this.partsCompleteMap.put(extension, true);
        }
    }

    public ExtensibleWizardPage(String pageName, String extensiblePageId, String pageTitle) throws CoreException {
        this(pageName, extensiblePageId, pageTitle, null);
    }

    private void loadWizardPagePartExtensions(String extensiblePageId) throws CoreException {
        List<WizardExtensionHolder> extensionPointObjects = this.getWizardExtensionHolders();
        Collections.sort(extensionPointObjects);
        for (WizardExtensionHolder holder : extensionPointObjects) {
            if (!extensiblePageId.equals(holder.getTargetWizardId())) continue;
            this.addExtension(holder.getExtension());
        }
    }

    protected boolean addExtension(WizardPagePartExtension wizardPagePartExtension) {
        ExtensiblePartStatusHandler statusHandler = new ExtensiblePartStatusHandler();
        statusHandler.addStatusListener(this);
        this.inject("statusHandler", statusHandler, wizardPagePartExtension);
        this.inject("wizardPage", this, wizardPagePartExtension);
        return this.extensions.add(wizardPagePartExtension);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayout((Layout)new FillLayout());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        final Composite container = new Composite((Composite)scrolledComposite, 0);
        for (WizardPagePartExtension extension : this.extensions) {
            Control extensionContainer = extension.createControl(container);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(extensionContainer);
        }
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.setControl((Control)scrolledComposite);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(container.computeSize(clientArea.width, -1));
            }
        });
        scrolledComposite.setContent((Control)container);
        this.calculateDialogNewProjectSize();
        this.initializeDefaults();
    }

    private void calculateDialogNewProjectSize() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        int studioWidth = parentShell.getBounds().width;
        int initDialogx = (studioWidth - 850) / 2;
        int height = preferenceStore.getBoolean("show_selection_api_on_new_project") ? 800 : 550;
        this.getShell().setBounds(parentShell.getBounds().x + initDialogx, parentShell.getBounds().y, 850, height);
    }

    private void initializeDefaults() {
        for (WizardPagePartExtension extension : this.extensions) {
            extension.initializeDefaults();
        }
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public void inject(String paramName, Object parameter) {
        for (WizardPagePartExtension extension : this.extensions) {
            this.inject(paramName, parameter, extension);
        }
    }

    private void inject(String paramName, Object parameter, Object extension) {
        List annotatedFields = ReflectionUtils.getAnnotatedFields(extension.getClass(), WizardContext.class);
        for (Field field : annotatedFields) {
            boolean fieldTypeMatches;
            WizardContext annotation = field.getAnnotation(WizardContext.class);
            if (annotation == null) continue;
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            boolean fieldNameMatches = fieldName.equals(paramName) || annotation.alias().equals(paramName);
            boolean bl = fieldTypeMatches = parameter == null || ReflectionUtils.isAssignableFrom(fieldType, (Object)parameter);
            if (!fieldNameMatches || !fieldTypeMatches) continue;
            ReflectionUtils.invokeSetter((String)fieldName, fieldType, (Object)parameter, (Object)extension);
        }
    }

    public void performFinish(IProgressMonitor monitor) {
        for (WizardPagePartExtension extension : this.extensions) {
            try {
                extension.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 100 / this.extensions.size()));
            }
            catch (Error e) {
                MuleCorePlugin.logError((String)("Fatal error executing extension " + extension.getClass().getName()), (Throwable)e);
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)("Error executing extension " + extension.getClass().getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationError(WizardPagePartExtension part, String errorMessage) {
        Map<WizardPagePartExtension, String> map = this.partsAndErrors;
        synchronized (map) {
            this.partsAndErrors.put(part, errorMessage);
            this.setErrorMessage(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onErrorsCleared(WizardPagePartExtension part) {
        Map<WizardPagePartExtension, String> map = this.partsAndErrors;
        synchronized (map) {
            String previousError = this.partsAndErrors.get(part);
            if (previousError != null) {
                this.partsAndErrors.remove(part);
            }
            if (this.partsAndErrors.values().isEmpty()) {
                this.setErrorMessage(null);
            } else {
                Collection<String> existingErrors = this.partsAndErrors.values();
                String newMessage = existingErrors.iterator().next();
                this.setErrorMessage(newMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPartComplete(WizardPagePartExtension part) {
        Map<WizardPagePartExtension, Boolean> map = this.partsCompleteMap;
        synchronized (map) {
            this.partsCompleteMap.put(part, true);
            boolean partsComplete = true;
            Collection<Boolean> values = this.partsCompleteMap.values();
            for (Boolean value : values) {
                partsComplete &= value.booleanValue();
            }
            this.setPageComplete(partsComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPartIncomplete(WizardPagePartExtension part) {
        Map<WizardPagePartExtension, Boolean> map = this.partsCompleteMap;
        synchronized (map) {
            this.partsCompleteMap.put(part, false);
            this.setPageComplete(false);
        }
    }

    @Override
    public void update(WizardPagePartExtension part, String key, Object value) {
        for (WizardPagePartExtension extension : this.extensions) {
            if (extension.equals(part)) continue;
            this.inject(key, value, extension);
        }
        this.inject(key, value, this);
    }

    protected List<WizardExtensionHolder> getWizardExtensionHolders() throws CoreException {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID_WIZARD_PAGE_PARTS);
        ArrayList<WizardExtensionHolder> extensionObjects = new ArrayList<WizardExtensionHolder>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                this.doLoadExtensionObject(extensionObjects, configurationElement);
            }
            catch (Throwable e) {
                MuleUIPlugin.getDefault().logError("There was an error initializing a WizardPagePartExtension", e);
            }
            ++n2;
        }
        return extensionObjects;
    }

    void doLoadExtensionObject(ArrayList<WizardExtensionHolder> extensionObjects, IConfigurationElement configurationElement) throws CoreException {
        IConfigurationElement[] children;
        WizardPagePartExtension extensionObject = (WizardPagePartExtension)WizardPagePartExtension.class.cast(configurationElement.createExecutableExtension("class"));
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren(CHILDREN_TARGET_WIZARD);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            WizardExtensionHolder extensionHolder = new WizardExtensionHolder(extensionObject, this.getTargetWizardPageId(child), this.getExtensionLevel(child));
            extensionObjects.add(extensionHolder);
            ++n2;
        }
    }

    private String getTargetWizardPageId(IConfigurationElement element) {
        return element.getAttribute(ATTRIBUTE_TARGET_WIZARD_ID);
    }

    private int getExtensionLevel(IConfigurationElement configurationElement) throws CoreException {
        try {
            String attribute = configurationElement.getAttribute(ATTRIBUTE_LEVEL);
            if (attribute != null) {
                Integer integerValue = Integer.valueOf(attribute);
                return integerValue;
            }
            return 10;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.ui", "Trying to load a WizardPagePartExtension that provided a non-numeric level"));
        }
    }

    protected class WizardExtensionHolder
    implements Comparable<WizardExtensionHolder> {
        private final WizardPagePartExtension extensionObject;
        private final int extensionLevel;
        private final String targetWizardId;

        public WizardExtensionHolder(WizardPagePartExtension extensionObject, String targetWizardId, int extensionLevel) {
            this.extensionObject = extensionObject;
            this.targetWizardId = targetWizardId;
            this.extensionLevel = extensionLevel;
        }

        public WizardPagePartExtension getExtension() {
            return this.extensionObject;
        }

        public int getExtensionLevel() {
            return this.extensionLevel;
        }

        public String getTargetWizardId() {
            return this.targetWizardId;
        }

        @Override
        public int compareTo(WizardExtensionHolder other) {
            return this.getExtensionLevel() - other.getExtensionLevel();
        }
    }
}

