/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards.extensible;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartStatusListener;

public class ExtensiblePartStatusHandler
implements PartStatusHandler {
    private boolean errorSet;
    private List<WizardPagePartStatusListener> listeners = new ArrayList<WizardPagePartStatusListener>();

    @Override
    public void clearErrors(WizardPagePartExtension part) {
        if (this.errorSet) {
            this.errorSet = false;
            for (WizardPagePartStatusListener listener : this.listeners) {
                listener.onErrorsCleared(part);
            }
        }
    }

    @Override
    public void setErrorMessage(WizardPagePartExtension part, String message) {
        for (WizardPagePartStatusListener listener : this.listeners) {
            listener.onConfigurationError(part, message);
        }
        this.errorSet = true;
    }

    @Override
    public void setPartComplete(WizardPagePartExtension part, boolean isComplete) {
        for (WizardPagePartStatusListener listener : this.listeners) {
            if (isComplete) {
                listener.onPartComplete(part);
                continue;
            }
            listener.onPartIncomplete(part);
        }
    }

    @Override
    public void notifyUpdate(WizardPagePartExtension part, String key, Object value) {
        for (WizardPagePartStatusListener listener : this.listeners) {
            listener.update(part, key, value);
        }
    }

    public void addStatusListener(WizardPagePartStatusListener listener) {
        this.listeners.add(listener);
    }

    public void removeStatusListener(WizardPagePartStatusListener listener) {
        this.listeners.remove(listener);
    }
}

