/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class WizardSettings {
    protected String settingsFileName;
    private IScopeContext projectScope;
    private IMuleProject muleProject;

    protected WizardSettings(IMuleProject muleProject, String settingsFileName) {
        this.muleProject = muleProject;
        this.projectScope = new ProjectScope(muleProject.getProject());
        this.settingsFileName = settingsFileName;
    }

    public static WizardSettings createProjectScope(IMuleProject muleProject, String settingsFileName) {
        return new WizardSettings(muleProject, settingsFileName);
    }

    public void saveSettings(String valueToBeSaved) {
        this.saveSettings(valueToBeSaved, 5);
    }

    public void saveSettings(String valueToBeSaved, int maxCount) {
        if (this.muleProject != null) {
            IEclipsePreferences projectNode = this.projectScope.getNode(this.settingsFileName);
            if (projectNode != null) {
                this.removeElement((Preferences)projectNode, valueToBeSaved);
                projectNode.put(Long.toString(Calendar.getInstance().getTimeInMillis()), valueToBeSaved);
            }
            try {
                String[] keys = projectNode.keys();
                int keysCount = keys.length;
                Arrays.sort(keys, Collections.reverseOrder(String.CASE_INSENSITIVE_ORDER));
                int i = 0;
                while (keysCount > maxCount) {
                    projectNode.remove(keys[i]);
                    --keysCount;
                    ++i;
                }
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean removeElement(Preferences projectNode, String valueToBeSaved) {
        try {
            String[] keys;
            String[] stringArray = keys = projectNode.keys();
            int n = keys.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String key = stringArray[n2];
                String element = projectNode.get(key, this.getName(this.muleProject));
                if (element.equals(valueToBeSaved)) {
                    projectNode.remove(key);
                    return true;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDefaultSettings() {
        String[] paths = this.getSavedSettings();
        if (this.muleProject != null) {
            if (paths.length >= 1) {
                return paths[paths.length - 1];
            }
            String name = this.getName(this.muleProject);
            String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + name;
            return filePath;
        }
        return "";
    }

    private String getName(IMuleProject muleProject) {
        return MuleProjectKind.DOMAIN.classifies(muleProject) ? ((IMuleDomainProject)MuleProjectKind.DOMAIN.adapt(muleProject)).getDomainName() : muleProject.getName();
    }

    public String[] getSavedSettings() {
        if (this.muleProject != null) {
            IEclipsePreferences projectNode = this.projectScope.getNode(this.settingsFileName);
            ArrayList<String> list = new ArrayList<String>();
            if (projectNode != null) {
                try {
                    String[] keys = projectNode.keys();
                    Arrays.sort(keys, Collections.reverseOrder(String.CASE_INSENSITIVE_ORDER));
                    String[] stringArray = keys;
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        list.add(projectNode.get(key, this.getName(this.muleProject)));
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    protected IScopeContext getProjectScope() {
        return this.projectScope;
    }

    protected IMuleProject getMuleProject() {
        return this.muleProject;
    }
}

