/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.MuleConfigurationGeneralPage;

public class NewMuleConfigurationFileWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "New Mule Configuration File";
    private MuleConfigurationGeneralPage general;
    private IMuleProject muleProject;

    public void addPages() {
        this.setWindowTitle(TITLE);
        super.addPages();
        this.general = new MuleConfigurationGeneralPage(this.muleProject);
        this.addPage((IWizardPage)this.general);
    }

    public boolean performFinish() {
        IMuleProject selectedMuleProject = this.general.getMuleProject();
        if (selectedMuleProject != null) {
            try {
                AnalyticsRecordsFactory.single((String)Events.MULE_CONFIGURATION_CREATED, (IMuleProject)selectedMuleProject).track();
                String configFilename = this.general.getMuleConfigurationFilename();
                IFolder targetFolder = this.general.getTargetFolder();
                CoreUtils.createEmptyXmlConfiguration((IMuleProject)selectedMuleProject, (String)configFilename);
                IFile configFile = targetFolder.getFile(configFilename);
                UiUtils.openEditorForFile(configFile);
                return true;
            }
            catch (IOException e) {
                MuleUIPlugin.openError(this.getShell(), e);
            }
            catch (CoreException e) {
                MuleUIPlugin.openError(this.getShell(), (Exception)((Object)e));
            }
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.muleProject = CoreUtils.getMuleProjectForSelection((IStructuredSelection)selection);
        }
        catch (CoreException e) {
            MuleUIPlugin.openError(this.getShell(), (Exception)((Object)e));
        }
    }
}

