/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.packageManager.MuleExportProperties;
import org.mule.tooling.core.packageManager.importing.LocateProjectsAction;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.FileChooserComposite;
import org.mule.tooling.ui.wizards.MuleProjectImportJob;

public class MuleZippedProjectImportPage
extends WizardPage {
    public static final String PAGE_ID = "muleZippedProjectImportPage";
    private FileChooserComposite projectFileChooser;
    private Text txtProjectName;
    private Group rootGroup;
    private LocateProjectsAction importAction;

    protected MuleZippedProjectImportPage(String pageName) {
        super(pageName);
        this.setTitle("Import Mule Project");
        this.setDescription("Import a Mule project from a deployable archive.");
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        control.setLayout((Layout)layout);
        Group externalGroup = new Group(control, 0);
        externalGroup.setLayout((Layout)new GridLayout(2, false));
        externalGroup.setLayoutData((Object)new GridData(768));
        externalGroup.setText("Project");
        Label pkgLabel = new Label((Composite)externalGroup, 0);
        pkgLabel.setText("File:");
        pkgLabel.setToolTipText("Choose the file of the project to import.");
        GridData data = new GridData(1);
        data.widthHint = 120;
        pkgLabel.setLayoutData((Object)data);
        this.projectFileChooser = new FileChooserComposite((Composite)externalGroup, 0);
        this.projectFileChooser.setFilterExtensions(new String[]{"*.jar"});
        this.projectFileChooser.setLayoutData(new GridData(768));
        this.projectFileChooser.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                MuleZippedProjectImportPage.this.updateSelectedRoot();
            }
        });
        this.rootGroup = new Group(control, 0);
        this.rootGroup.setLayout((Layout)new GridLayout(2, false));
        this.rootGroup.setLayoutData((Object)new GridData(768));
        this.rootGroup.setText("Mule Project");
        Label pnameLabel = new Label((Composite)this.rootGroup, 0);
        pnameLabel.setText("Project Name:");
        pnameLabel.setToolTipText("Choose the name of the Mule project to be created.");
        data = new GridData(1);
        data.widthHint = 120;
        pkgLabel.setLayoutData((Object)data);
        this.txtProjectName = new Text((Composite)this.rootGroup, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(768));
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    List availableProjectNames = MuleZippedProjectImportPage.this.importAction.getAvailableProjectNames();
                    if (!availableProjectNames.isEmpty()) {
                        String srcProjectName = (String)availableProjectNames.get(0);
                        MuleZippedProjectImportPage.this.importAction.rename(srcProjectName, MuleZippedProjectImportPage.this.txtProjectName.getText());
                    }
                }
                catch (IOException e1) {
                    MuleCorePlugin.logError((String)("There was a problem reading available projects from file " + MuleZippedProjectImportPage.this.projectFileChooser.getFilePath()), (Throwable)e1);
                }
                MuleZippedProjectImportPage.this.updatePageComplete();
            }
        });
        this.rootGroup.setVisible(false);
        this.setControl((Control)control);
        this.setPageComplete(false);
    }

    protected void updatePageComplete() {
        boolean complete = true;
        if (this.rootGroup.isVisible()) {
            String projectName = this.txtProjectName.getText();
            if (StringUtils.isEmpty((String)this.projectFileChooser.getFilePath())) {
                this.setErrorMessage("A file must be chosen.");
                complete = false;
            } else if (!this.getZipChooserFile().exists()) {
                this.setErrorMessage("File does not exist.");
                complete = false;
            } else if (StringUtils.isEmpty((String)projectName)) {
                this.setErrorMessage("Project name must not be empty.");
                complete = false;
            } else if (StringUtils.contains((String)projectName, (char)' ')) {
                this.setErrorMessage("Project name must not contain spaces.");
                complete = false;
            } else {
                ProjectImportAction.ImportValidationResult result = this.importAction.validateAllActions();
                if (result.isSuccessful()) {
                    this.setErrorMessage(null);
                } else {
                    List errorMessages = result.getErrorMessages();
                    String message = errorMessages.stream().collect(Collectors.joining(System.lineSeparator()));
                    this.setErrorMessage(message);
                    complete = false;
                }
            }
        } else {
            File zipChooserFile = this.getZipChooserFile();
            if (!zipChooserFile.exists() || zipChooserFile.isDirectory()) {
                this.setErrorMessage("File does not exist.");
                complete = false;
            } else {
                try {
                    List<String> zippedProjectsNames = this.getZippedProjects(zipChooserFile);
                    boolean found = false;
                    for (String projectName : zippedProjectsNames) {
                        File newProject = new File(CoreUtils.getWorkspaceLocation(), projectName);
                        if (!newProject.exists()) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        this.setErrorMessage("Some projects from the selected zip already exist in your workspace. Projects in zip: " + String.valueOf(zippedProjectsNames));
                        complete = false;
                    } else {
                        this.setErrorMessage(null);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.setPageComplete(complete);
    }

    protected void updateSelectedRoot() {
        File file = this.getZipChooserFile();
        if (file.exists() && !file.isDirectory()) {
            this.importAction = new LocateProjectsAction(file, ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
            this.updateFileName(file);
        }
        this.updatePageComplete();
    }

    private void updateFileName(File file) {
        this.rootGroup.setVisible(true);
        String safeName = this.getSafeName(file.getName());
        if (!StringUtils.isEmpty((String)safeName)) {
            String extension = ".jar";
            if (safeName.endsWith(extension)) {
                safeName = safeName.substring(0, safeName.lastIndexOf(extension));
            }
            this.txtProjectName.setText(safeName);
        }
    }

    private File getZipChooserFile() {
        return new File(this.projectFileChooser.getFilePath());
    }

    public void setFilePath(String filePath) {
        this.projectFileChooser.setFilePath(filePath);
    }

    private List<String> getZippedProjects(File zip) throws IOException {
        String projectsInZip = (String)this.getPropertyFromZippedProject(zip, "mule_exported_projects");
        return projectsInZip != null ? Arrays.asList(projectsInZip.split(",")) : this.getZippedProjectsListingZips(zip);
    }

    private List<String> getZippedProjectsListingZips(File zip) {
        ArrayList<String> apps = new ArrayList<String>();
        Pattern pattern = Pattern.compile("META-INF/(.*)\\.zip");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zipFile = new ZipFile(zip);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry nextElement = entries.nextElement();
                    Matcher matcher = pattern.matcher(nextElement.getName());
                    if (!matcher.matches()) continue;
                    String appName = matcher.group(1);
                    apps.add(appName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error opening zip file", (Throwable)e);
        }
        return apps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getPropertyFromZippedProject(File zip, String property) throws IOException {
        String propertyValue = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(zip.toPath());){
            Path path = zipFileSystem.getPath("/META-INF", "mule_export.properties");
            if (!Files.exists(path, new LinkOption[0])) return propertyValue;
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (InputStream newBufferedReader = Files.newInputStream(path, StandardOpenOption.READ);){
                MuleExportProperties muleExportProperties = MuleExportProperties.load((InputStream)newBufferedReader);
                switch (property) {
                    case "mule_export_version": {
                        propertyValue = muleExportProperties.getExportVersion();
                        return propertyValue;
                    }
                    case "mule_exported_projects": {
                        propertyValue = muleExportProperties.getExportedProjects();
                        return propertyValue;
                    }
                }
                return propertyValue;
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                    throw throwable2;
                }
                if (throwable2 == throwable3) throw throwable2;
                throwable2.addSuppressed(throwable3);
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    protected String getSafeName(String input) {
        return input.toLowerCase().replace(' ', '_');
    }

    public boolean performFinish() {
        File tempExpandedZipFile;
        String projectName;
        long startTime;
        block9: {
            File projectFile;
            block8: {
                File workspaceDir;
                block7: {
                    block6: {
                        startTime = System.currentTimeMillis();
                        try {
                            String projectFileName = this.projectFileChooser.getFilePath();
                            projectFile = new File(projectFileName);
                            projectName = this.txtProjectName.getText();
                            if (projectFile.exists()) break block6;
                            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"File does not exist.");
                            return false;
                        }
                        catch (IOException e) {
                            this.trackImport(Events.FAILED_IMPORT_PROJECT, startTime).track();
                            throw new RuntimeException(e);
                        }
                    }
                    if (projectFile.getName().endsWith(".jar") && projectFile.isFile()) break block7;
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"The selection is not a .jar file.");
                    return false;
                }
                if (StringUtils.isEmpty((String)projectName) || !new File(workspaceDir = CoreUtils.getWorkspaceLocation(), projectName).exists()) break block8;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"A project with the given name already exists.");
                return false;
            }
            tempExpandedZipFile = CoreUtils.unzipFileToTemp((File)projectFile);
            if (CoreUtils.hasExpectedProjectStructure((File)tempExpandedZipFile)) break block9;
            this.trackImport(Events.FAILED_IMPORT_PROJECT, startTime).addMetadata("cause", "invalid structure").track();
            boolean decision = MessageDialog.open((int)5, (Shell)this.getShell(), (String)"Warning", (String)"The project you are trying to import has an invalid folder structure. \nContinue anyway?", (int)0);
            if (decision) break block9;
            return false;
        }
        String tempRepository = tempExpandedZipFile.getPath() + File.separator + "repository";
        MuleProjectImportJob importProjectJob = new MuleProjectImportJob((ProjectImportAction)this.importAction, projectName, tempRepository);
        importProjectJob.schedule();
        this.trackImport(Events.IMPORT_PROJECT, startTime).track();
        return true;
    }

    private AnalyticsRecordsFactory trackImport(String metricId, long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        return AnalyticsRecordsFactory.single((String)metricId, (String[])new String[]{"importType", "Jar", "exportTimeMillis", String.valueOf(elapsedTime)});
    }
}

