/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.packageManager.importing.CopyToWorkspaceAction;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.common.FolderChooserComposite;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.wizards.MuleProjectImportJob;

public class MuleProjectImportPage
extends WizardPage {
    public static final String PAGE_ID = "muleProjectImportPage";
    private FolderChooserComposite rootChooser;
    private Text txtProjectName;
    protected ComboViewer runtimeCombo;
    private Button copyCheckbox;
    private File rootFile;
    private File muleProjectFile;
    private Optional<CopyToWorkspaceAction> importAction = Optional.empty();

    protected MuleProjectImportPage(String pageName) {
        super(pageName);
        this.setTitle("Import Mule Project");
        this.setDescription("Import a Mule project from an external folder (expanded zip or Studio project in the file system).");
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        control.setLayout((Layout)layout);
        Group externalGroup = new Group(control, 0);
        externalGroup.setLayout((Layout)new GridLayout(2, false));
        externalGroup.setLayoutData((Object)new GridData(768));
        externalGroup.setText("External Project");
        Label pkgLabel = new Label((Composite)externalGroup, 0);
        pkgLabel.setText("Project Root:");
        pkgLabel.setToolTipText("Choose the root folder of the project to import.");
        GridData data = new GridData(1);
        data.widthHint = 120;
        pkgLabel.setLayoutData((Object)data);
        this.rootChooser = new FolderChooserComposite((Composite)externalGroup, 0);
        this.rootChooser.setLayoutData(new GridData(768));
        this.rootChooser.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                MuleProjectImportPage.this.updateSelectedRoot();
            }
        });
        Group rootGroup = new Group(control, 0);
        rootGroup.setLayout((Layout)new GridLayout(2, false));
        rootGroup.setLayoutData((Object)new GridData(768));
        rootGroup.setText("Mule Project");
        Label pnameLabel = new Label((Composite)rootGroup, 0);
        pnameLabel.setText("Project Name:");
        pnameLabel.setToolTipText("Choose the name of the Mule project to be created.");
        data = new GridData(1);
        data.widthHint = 120;
        pkgLabel.setLayoutData((Object)data);
        this.txtProjectName = new Text((Composite)rootGroup, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(768));
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MuleProjectImportPage.this.importAction.ifPresent(action -> action.setProjectName(MuleProjectImportPage.this.txtProjectName.getText()));
                MuleProjectImportPage.this.updatePageComplete();
            }
        });
        List runtimes = MuleCorePlugin.getServerManager().getServerDefinitions();
        data = new GridData(1, 0x1000000, false, false);
        data.widthHint = 120;
        Label rtLabel = new Label((Composite)rootGroup, 0);
        rtLabel.setText("Server Runtime:");
        rtLabel.setToolTipText("Choose a server runtime.");
        rtLabel.setLayoutData((Object)data);
        this.runtimeCombo = new ComboViewer((Composite)rootGroup, 76);
        this.runtimeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runtimeCombo.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
        this.runtimeCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.runtimeCombo.setInput((Object)runtimes);
        if (runtimes.size() > 0) {
            this.runtimeCombo.setSelection((ISelection)new StructuredSelection(runtimes.get(0)));
        }
        this.runtimeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.copyCheckbox = new Button(control, 32);
        this.copyCheckbox.setText("Copy project into workspace");
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MuleProjectImportPage.this.importAction.ifPresent(action -> action.setCopyToWorkspace(MuleProjectImportPage.this.copyCheckbox.getSelection()));
                MuleProjectImportPage.this.updateSelectedRoot();
            }
        });
        this.copyCheckbox.setSelection(true);
        this.setControl((Control)control);
        this.setPageComplete(false);
    }

    protected void updatePageComplete() {
        boolean complete = true;
        String projectName = this.txtProjectName.getText();
        if (StringUtils.isNotEmpty((String)this.rootChooser.getFolderPath()) && this.muleProjectFile == null) {
            this.setErrorMessage("The selected folder does not contain a valid Studio project (missing pom.xml file)");
            complete = false;
        } else if (StringUtils.isEmpty((String)this.rootChooser.getFolderPath()) || this.muleProjectFile == null) {
            this.setMessage(null);
            this.setErrorMessage(null);
            complete = false;
        } else if (StringUtils.isEmpty((String)projectName)) {
            this.setErrorMessage("Project name may not be empty.");
            complete = false;
        } else {
            ProjectImportAction.ImportValidationResult result = this.importAction.map(action -> action.validateAllActions()).orElse(ProjectImportAction.EMPTY_VALIDATION_RESULT);
            if (result.isSuccessful()) {
                this.setMessage(null);
                this.setErrorMessage(null);
            } else {
                String message = result.getErrorMessages().stream().collect(Collectors.joining(System.lineSeparator()));
                this.setErrorMessage(message);
                complete = false;
            }
        }
        this.setPageComplete(complete);
    }

    private static boolean isProjectNameAvailable(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return false;
        }
        return workspace.validateProjectLocation(project, null).isOK();
    }

    protected void updateSelectedRoot() {
        this.rootFile = new File(this.rootChooser.getFolderPath());
        this.muleProjectFile = new File(this.rootFile, "pom.xml");
        if (this.muleProjectFile.exists()) {
            try {
                IMuleProjectModel loadedProject = MuleResourceUtils.loadMuleProjectModel((File)this.muleProjectFile);
                this.importAction = Optional.of(new CopyToWorkspaceAction(this.rootFile, loadedProject.getName(), this.copyCheckbox.getSelection()));
                this.txtProjectName.setText(loadedProject.getName());
                IServerDefinition runtimeVersion = loadedProject.getRuntimeQualifier().map(runtimeQualifier -> MuleCorePlugin.getServerManager().getServerDefinition(runtimeQualifier)).orElse(null);
                if (runtimeVersion != null) {
                    this.runtimeCombo.setSelection((ISelection)new StructuredSelection((Object)runtimeVersion));
                }
            }
            catch (IOException e) {
                MuleUIPlugin.getDefault().logError("Problem loading project model ", e);
            }
        } else {
            this.muleProjectFile = null;
            this.rootFile = null;
        }
        this.updatePageComplete();
    }

    protected String getSelectedRuntimeId() {
        StructuredSelection selection = (StructuredSelection)this.runtimeCombo.getSelection();
        IServerDefinition selected = (IServerDefinition)selection.getFirstElement();
        return selected != null ? selected.getId() : null;
    }

    public boolean performFinish() {
        long startTime = System.currentTimeMillis();
        if (!this.rootFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Project root folder does not exist.");
            return false;
        }
        String projectName = this.txtProjectName.getText();
        if (!MuleProjectImportPage.isProjectNameAvailable(projectName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"A project with the given name already exists.");
            return false;
        }
        boolean copyToWorkspace = this.copyCheckbox.getSelection();
        ISelection selection = this.runtimeCombo.getSelection();
        String runtimeId = ((IServerDefinition)((StructuredSelection)selection).getFirstElement()).getId();
        if (!CoreUtils.hasStudioWorkspaceProjectStructure((File)this.rootFile)) {
            this.trackImportPackageMetric(Events.FAILED_IMPORT_PROJECT, startTime).addMetadata("cause", "invalid structure").track();
            if (copyToWorkspace) {
                boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Invalid Project Structure", (String)"Selected Project does not have expected structure. Continue anyway? ");
                if (!confirm) {
                    return false;
                }
            } else {
                MessageDialog.open((int)1, (Shell)this.getShell(), (String)"", (String)"The project you are trying to import doesn't have the expected structure. \n\nNote: When not copying the project to the workspace, the imported project has to comply with the structure used in Studio workspaces.", (int)0);
                return false;
            }
        }
        MuleProjectImportJob changeClasspathJob = new MuleProjectImportJob((ProjectImportAction)this.importAction.get(), this.importAction.get().getProjectName(), runtimeId);
        changeClasspathJob.schedule();
        this.trackImportPackageMetric(Events.IMPORT_PROJECT, startTime).track();
        return true;
    }

    private AnalyticsRecordsFactory trackImportPackageMetric(String metricId, long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        AnalyticsRecordsFactory metric = AnalyticsRecordsFactory.single((String)metricId, (String[])new String[]{"importType", "workspace", "copyProjectIntoWorkspace", String.valueOf(this.copyCheckbox.getSelection()), "exportTimeMillis", String.valueOf(elapsedTime)});
        return metric;
    }
}

