/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.DependencyResolutionException;
import org.mule.tooling.core.m2.InstallationException;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.DependencyResolutionResult;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.MuleMavenClientResolver;
import org.mule.tooling.core.m2.internal.markers.DependencyResolutionRule;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MuleProjectImportJob
extends WorkspaceJob {
    private static final int TASK_SIZE = 1000;
    private static final String SERVER_PREFIX = "org.mule.tooling.server.";
    private static final String SERVER_SUFFIX = ".ee";
    private final ProjectImportAction importAction;
    private final String runtimeId;
    private final String tempRepository;
    private DependencyResolutionRule resolveDependenciesRule;
    private DependencyResolutionRule resolvePluginsRule;
    private Callback<Map<MavenDependency, File>> dependencyCallback;
    private Callback<List<ExternalContributionMuleModule>> pluginCallback;
    private AtomicBoolean installDep = null;

    public MuleProjectImportJob(ProjectImportAction importAction, String projectName, String pathTemporal) {
        this(importAction, projectName, null, pathTemporal, true);
    }

    public MuleProjectImportJob(ProjectImportAction importAction, final String projectName, String runtimeId, String pathTemporal, boolean openEditor) {
        super("Mule Import");
        this.importAction = importAction;
        this.runtimeId = runtimeId;
        this.tempRepository = pathTemporal;
        this.setUser(true);
        if (openEditor) {
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getJob().getResult().isOK()) {
                        UiUtils.showFirstFlowInProject(projectName);
                    }
                }
            });
        }
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Importing project", (int)2000);
        ImportActionResult result = this.importAction.runAllActions((IProgressMonitor)submonitor.newChild(1000));
        if (!result.isSuccessful()) {
            throw result.getException().orElse(new CoreException((IStatus)new Status(4, "org.mule.tooling.ui", "Unspecified error importing project")));
        }
        List muleProjects = (List)result.getMuleProjects().orElseThrow(this.noProjectsException());
        int ticksPerProject = 1000 / muleProjects.size();
        submonitor.subTask("Downloading imported project dependencies");
        IArtifactResolvingRunner runner = ArtifactResolvingRunnerFactory.syncInstance();
        for (IMuleProject muleProject : muleProjects) {
            List<MavenDependency> extensions = muleProject.getDeclaredExtensions().stream().map(MavenUtils::getDependency).collect(Collectors.toList());
            List dependencies = muleProject.getDeclaredDependencies();
            runner.runResolvingExtensions(muleProject, extensions, ExtensionsCallback.builder().onError(error -> {
                this.resolvePluginsRule = DependencyResolutionRule.withErrors((Map)error);
            }).build(), (IProgressMonitor)submonitor.newChild(ticksPerProject / 2));
            this.resolvingPluginAndDependenciesExternal(submonitor, ticksPerProject, runner, muleProject, this.resolvePluginsRule, extensions, true);
            runner.runResolvingDependencies(muleProject, dependencies, DependenciesCallback.builder().onError(error -> {
                this.resolveDependenciesRule = DependencyResolutionRule.withErrors((Map)error);
            }).build(), DependencyResolutionConfiguration.createDefault().includeProvidedScope(), (IProgressMonitor)submonitor.newChild(ticksPerProject / 2));
            this.resolvingPluginAndDependenciesExternal(submonitor, ticksPerProject, runner, muleProject, this.resolveDependenciesRule, dependencies, false);
            String runtimeIdToChange = this.runtimeId;
            if (this.runtimeId == null) {
                runtimeIdToChange = this.getRuntimeVersionIdFromPom(muleProject);
            }
            if (runtimeIdToChange == null) continue;
            try {
                List serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
                if (!serverDefinitions.toString().contains(runtimeIdToChange)) continue;
                muleProject.changeRuntime(runtimeIdToChange);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("There was a problem changing the runtime version for project " + muleProject.getName()), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    protected void resolvingPluginAndDependenciesExternal(SubMonitor submonitor, int ticksPerProject, IArtifactResolvingRunner runner, IMuleProject muleProject, DependencyResolutionRule dependenciesRule, List<MavenDependency> dependencies, boolean isPlugin) {
        if (dependenciesRule != null) {
            if (this.shouldResolveWithLocal(dependencies, muleProject, dependenciesRule)) {
                if (isPlugin) {
                    this.resolvingExtensions(submonitor, ticksPerProject, runner, muleProject, dependenciesRule, dependencies);
                } else {
                    this.resolvingDependencies(submonitor, ticksPerProject, runner, muleProject, dependenciesRule, dependencies);
                }
            } else {
                ArtifactResolvingRunnerFactory.ON_ERROR_LOG.accept(dependenciesRule.getExceptionsMap());
            }
        }
    }

    protected void resolvingExtensions(SubMonitor submonitor, int ticksPerProject, IArtifactResolvingRunner runner, IMuleProject muleProject, DependencyResolutionRule dependenciesRule, List<MavenDependency> dependencies) {
        if (this.pluginCallback == null) {
            this.pluginCallback = ExtensionsCallback.builder().onErrorLog().onSuccess(sucess -> {
                try {
                    for (ExternalContributionMuleModule contributionMuleModule : sucess) {
                        MavenDependency dependency = (MavenDependency)contributionMuleModule.getCoordinates();
                        if (MavenDependency.Scope.TEST.equals((Object)dependency.getScope())) {
                            muleProject.addMuleTestExtension(contributionMuleModule);
                            continue;
                        }
                        muleProject.addMuleExtension(contributionMuleModule);
                    }
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError((String)"Error solving plugins ", (Throwable)e);
                }
            }).build();
        }
        runner.runResolvingExtensions(muleProject, dependencies, this.pluginCallback, (IProgressMonitor)submonitor.newChild(ticksPerProject / 2));
    }

    protected void resolvingDependencies(SubMonitor submonitor, int ticksPerProject, IArtifactResolvingRunner runner, IMuleProject muleProject, DependencyResolutionRule dependenciesRule, List<MavenDependency> dependencies) {
        if (this.dependencyCallback == null) {
            this.dependencyCallback = DependenciesCallback.builder().onErrorLog().onSuccess(sucess -> {
                BaseMuleProject project = (BaseMuleProject)muleProject;
                ArrayList<MavenDependency> nonApideps = new ArrayList<MavenDependency>();
                for (MavenDependency dep : sucess.keySet()) {
                    if (dep.getClassifier().map(CoreUtils::isAPIClassifier).orElse(false).booleanValue()) {
                        project.addAPISpecDependency(dep);
                        continue;
                    }
                    nonApideps.add(dep);
                }
                if (!nonApideps.isEmpty()) {
                    project.updateDependencies(nonApideps, muleProject);
                }
            }).build();
        }
        runner.runResolvingDependencies(muleProject, dependencies, this.dependencyCallback, DependencyResolutionConfiguration.createDefault().includeProvidedScope(), (IProgressMonitor)submonitor.newChild(ticksPerProject / 2));
    }

    private String getRuntimeVersionIdFromPom(IMuleProject muleProject) {
        MavenMuleProjectDecorator mavenMuleProjectDecorator = MavenMuleProjectDecorator.decorate((IMuleProject)muleProject);
        String runtimeVersionFromPom = (String)mavenMuleProjectDecorator.getProperties().get("app.runtime");
        if (runtimeVersionFromPom != null) {
            String nakedVersion = runtimeVersionFromPom.substring(0, 5);
            return SERVER_PREFIX + nakedVersion + SERVER_SUFFIX;
        }
        return null;
    }

    private Supplier<? extends IllegalStateException> noProjectsException() {
        return () -> new IllegalStateException("Project import was successful but no mule projects where imported");
    }

    private boolean shouldResolveWithLocal(List<MavenDependency> dependencies, IMuleProject muleProject, DependencyResolutionRule dependenciesRule) {
        if (this.installDep == null) {
            this.installDep = new AtomicBoolean();
            Display.getDefault().syncExec(() -> this.installDep.set(this.openLocalInstallDialog(dependencies)));
        }
        if (this.installDep.get()) {
            return this.installExternalDependencies(dependencies, muleProject, dependenciesRule);
        }
        return false;
    }

    private boolean installExternalDependencies(List<MavenDependency> dependencies, IMuleProject muleProject, DependencyResolutionRule dependenciesRule) {
        if (this.tempRepository != null) {
            List<MavenDependency> fullDependenciesList = !dependencies.isEmpty() && MavenUtils.isMulePlugin((MavenDependency)dependencies.get(0)) ? dependencies : this.resolveDependenciesIncludedInJar(muleProject, dependencies, dependenciesRule.getExceptionsMap().keySet());
            int index = fullDependenciesList.size() - 1;
            while (index >= 0) {
                MavenDependency artifact = fullDependenciesList.get(index);
                String pathJar = MavenResourceUtils.getRepositoryPath((MavenDependency)artifact, (String)File.separator);
                String pathPom = MavenResourceUtils.getRepositoryPath((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (Optional)artifact.getClassifier(), Optional.of("pom"), (String)File.separator);
                File jarFile = new File(this.tempRepository + File.separator + pathJar);
                File pomFile = new File(this.tempRepository + File.separator + pathPom);
                Optional<Object> pom = pomFile.exists() ? Optional.ofNullable(pomFile) : Optional.empty();
                try {
                    if (jarFile.exists()) {
                        MavenUtils.installFileToLocalRepository((File)jarFile, pom, (MavenDependency)artifact);
                    } else if (pomFile.exists()) {
                        MavenUtils.installPomToLocalRepository((File)pomFile, (MavenDependency)artifact);
                    }
                }
                catch (InstallationException installException) {
                    MuleCorePlugin.logError((String)"Some artifacts could not be installed correctly", (Throwable)installException);
                }
                --index;
            }
            return true;
        }
        return false;
    }

    public String getTempRepository() {
        return this.tempRepository;
    }

    private List<MavenDependency> resolveDependenciesIncludedInJar(IMuleProject muleProject, List<MavenDependency> dependencies, Set<MavenDependency> failedDependencies) {
        List<Object> dependenciesToInstall = Collections.emptyList();
        try {
            MavenConfiguration mavenConfiguration = MavenConfiguration.newMavenConfigurationBuilder().localMavenRepositoryLocation(new File(this.tempRepository)).offlineMode(true).build();
            MuleMavenClientResolver resolver = new MuleMavenClientResolver(MavenCore.getUserSettings(), mavenConfiguration, session -> {});
            DependencyResolutionConfiguration resolutionConfig = DependencyResolutionConfiguration.createDefault().withResolverFactory(sessionConfigurator -> resolver);
            dependenciesToInstall = resolver.resolveDependencies(muleProject, failedDependencies, resolutionConfig, null).stream().map(DependencyResolutionResult::getDependency).collect(Collectors.toList());
        }
        catch (DependencyResolutionException depException) {
            MuleCorePlugin.logError((String)"Some transitive dependencies could not be resolved.", (Throwable)depException);
        }
        return dependenciesToInstall;
    }

    protected boolean openLocalInstallDialog(List<MavenDependency> dependencies) {
        ScopedPreferenceStore preferenceStore = MuleCorePlugin.getScopedPreferenceStore();
        MuleStudioPreferencePage.ActionDialogState runServerState = MuleStudioPreferencePage.ActionDialogState.fromPreference((IPreferenceStore)preferenceStore, "mule_core_plugin_preference_install_external_dependencies");
        if (runServerState.isAlways()) {
            return true;
        }
        if (runServerState.prompt()) {
            MessageDialogWithToggle openYesNoQuestion = MessageDialogWithToggle.openYesNoQuestion((Shell)WidgetUtils.getShell(), (String)"Install all dependencies", (String)"Confirm that you want to include project modules and third-party dependencies?", (String)"Don't ask again.", (boolean)false, (IPreferenceStore)MuleCorePlugin.getScopedPreferenceStore(), (String)"mule_core_plugin_preference_install_external_dependencies");
            if (openYesNoQuestion.getReturnCode() == 2) {
                if (openYesNoQuestion.getToggleState()) {
                    preferenceStore.setValue("mule_core_plugin_preference_install_external_dependencies", MuleStudioPreferencePage.ActionDialogState.ALWAYS.name());
                }
                return true;
            }
            if (openYesNoQuestion.getReturnCode() == 3 && openYesNoQuestion.getToggleState()) {
                preferenceStore.setValue("mule_core_plugin_preference_install_external_dependencies", MuleStudioPreferencePage.ActionDialogState.NEVER.name());
            }
        }
        return false;
    }

    public void setDependencyCallback(Callback<Map<MavenDependency, File>> dependencyCallback) {
        this.dependencyCallback = dependencyCallback;
    }

    public void setPluginCallback(Callback<List<ExternalContributionMuleModule>> pluginCallback) {
        this.pluginCallback = pluginCallback;
    }

    public void setInstallDep(AtomicBoolean installDep) {
        this.installDep = installDep;
    }
}

