/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.wizards.MuleDomainProjectExportPage;
import org.mule.tooling.ui.wizards.MuleProjectExportPage;

public class MuleProjectExportWizard
extends Wizard
implements IExportWizard {
    private static final String MULE_PROJECT_SECTION = "MuleProjectExportWizard";
    private IMuleProject selected;
    private MuleProjectExportPage mainPage;

    public MuleProjectExportWizard() {
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = MuleUIPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection(MULE_PROJECT_SECTION);
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection(MULE_PROJECT_SECTION);
        }
        this.setDialogSettings(wizardSettings);
        this.setWindowTitle("Export Mule Project");
    }

    public void addPages() {
        super.addPages();
        if (this.selected == null) {
            this.addPage((IWizardPage)new MuleProjectChooserPage());
        } else {
            this.mainPage = this.getPageForProject();
            this.addPage((IWizardPage)this.mainPage);
        }
    }

    private MuleProjectExportPage getPageForProject() {
        if (MuleProjectKind.DOMAIN.classifies(this.selected)) {
            return new MuleDomainProjectExportPage(this.selected);
        }
        return new MuleProjectExportPage(this.selected);
    }

    private MuleProjectExportPage getMainPage() {
        this.mainPage = this.getPageForProject();
        return this.mainPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.selected = CoreUtils.getMuleProjectForSelection((IStructuredSelection)selection);
        }
        catch (CoreException e) {
            MuleUIPlugin.openError(this.getShell(), (Exception)((Object)e));
        }
    }

    public boolean canFinish() {
        return this.selected != null && this.mainPage != null;
    }

    public boolean performFinish() {
        return this.mainPage.performFinish();
    }

    public synchronized IMuleProject getSelectedProject() {
        return this.selected;
    }

    public synchronized void setSelectedProject(IMuleProject selected) {
        this.selected = selected;
        this.mainPage = null;
        this.getContainer().updateButtons();
    }

    private static class MuleProjectChooserPage
    extends WizardPage {
        public static final String PAGE_ID = "muleProjectChooserPage";
        private static final String EXPORT_TITLE = "Select project";
        private static final String SELECT_PROJECT_LABEL_TEXT = "Please, select project to export: ";
        private static final String NO_MULE_PROJECTS = "There are no Mule projects to be exported";
        private TableViewer projectsTable;
        private Composite control;
        private IMuleProject selected;

        protected MuleProjectChooserPage() {
            super(PAGE_ID);
            this.setTitle(this.getExportTitle());
        }

        public void createControl(Composite parent) {
            this.control = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(this.control);
            GridDataFactory.fillDefaults().applyTo((Control)this.control);
            Group projectGroup = new Group(this.control, 0);
            GridLayoutFactory.fillDefaults().applyTo((Composite)projectGroup);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectGroup);
            this.setControl((Control)this.control);
            CLabel projectLabel = new CLabel((Composite)projectGroup, 0);
            projectLabel.setText(SELECT_PROJECT_LABEL_TEXT);
            IMuleProject[] muleProjects = MuleRuntime.getMuleProjects();
            if (muleProjects.length == 0) {
                projectLabel.setText(NO_MULE_PROJECTS);
                return;
            }
            this.selected = muleProjects[0];
            this.projectsTable = new TableViewer((Composite)projectGroup, 2816);
            this.projectsTable.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
            this.projectsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.projectsTable.setInput((Object)muleProjects);
            this.projectsTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        selected = null;
                        this.setErrorMessage("Must select a project to continue");
                    } else {
                        selected = (IMuleProject)selection.getFirstElement();
                        this.setErrorMessage(null);
                    }
                    MuleProjectExportWizard wizard = (MuleProjectExportWizard)this.getWizard();
                    wizard.setSelectedProject(selected);
                    wizard.getContainer().updateButtons();
                }
            });
            this.projectsTable.setSelection((ISelection)new StructuredSelection((Object)this.selected));
            GridLayoutFactory.fillDefaults().applyTo((Composite)this.projectsTable.getTable());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectsTable.getTable());
        }

        public boolean isPageComplete() {
            return this.selected != null;
        }

        public boolean canFlipToNextPage() {
            return this.isPageComplete();
        }

        public IWizardPage getNextPage() {
            if (this.selected != null) {
                MuleProjectExportWizard wizard = (MuleProjectExportWizard)this.getWizard();
                MuleProjectExportPage nextPage = wizard.getMainPage();
                nextPage.setWizard((IWizard)wizard);
                return nextPage;
            }
            return super.getNextPage();
        }

        public String getExportTitle() {
            return EXPORT_TITLE;
        }
    }
}

