/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.model.ProjectModelState;
import org.mule.tooling.core.packageManager.MuleExportRunnable;
import org.mule.tooling.core.packageManager.MuleExportStatus;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MessageDialogUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.jface.MuleContentProvider;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.jface.ProjectExportWizardContentProvider;
import org.mule.tooling.ui.utils.SaveModifiedResourcesDialog;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.errors.ErrorActionDialog;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.ui.wizards.WizardSettings;

public class MuleProjectExportPage
extends WizardPage {
    private static final String EXPORT_DESCRIPTION = "Export a Mule project as a deployable archive.";
    private static final String EXPORT_TITLE = "Export Mule Project";
    public static final String PAGE_ID = "muleProjectExportPage";
    protected IMuleProject muleProject;
    protected ComboViewer projects;
    private Composite control;
    private String outputAbsolutePath;
    private ComboViewer comboFileName;
    private Button browseButton;
    private Button attachSourcesButton;
    private Button includeDependencies;
    private Button onlySources;
    protected Button includeLinkedProjectsButton;
    private WizardSettings currentWizardSettings;
    private static final String PROJECT_SETTINGS_FILE_NAME = "org.mulesoft.exportwizardsettings";

    protected MuleProjectExportPage(IMuleProject muleProject) {
        super(PAGE_ID);
        this.setTitle(this.getExportTitle());
        this.setDescription(this.getExportDescription());
        this.muleProject = muleProject;
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.control.setLayout((Layout)layout);
        this.addWarningMessage(this.control);
        Group exportGroup = new Group(this.control, 0);
        layout = new GridLayout(3, false);
        exportGroup.setLayout((Layout)layout);
        exportGroup.setLayoutData((Object)new GridData(768));
        exportGroup.setText("Export Settings");
        GridData gd = new GridData(1);
        gd.widthHint = 100;
        if (this.muleProject == null) {
            this.createProjectsCombo(exportGroup, gd);
        } else {
            this.currentWizardSettings = WizardSettings.createProjectScope(this.muleProject, PROJECT_SETTINGS_FILE_NAME);
        }
        Label outputFileName = new Label((Composite)exportGroup, 0);
        outputFileName.setText("JAR file:");
        outputFileName.setToolTipText("The path of the file which will be generated.");
        outputFileName.setLayoutData((Object)gd);
        this.comboFileName = new ComboViewer((Composite)exportGroup, 516);
        this.comboFileName.getCombo().setLayoutData((Object)new GridData(768));
        this.comboFileName.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboFileName.setContentProvider((IContentProvider)new ProjectExportWizardContentProvider());
        this.comboFileName.setInput((Object)this.currentWizardSettings);
        this.comboFileName.getCombo().setToolTipText("The name for the archive that will be generated.");
        this.comboFileName.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MuleProjectExportPage.this.comboFileName.getSelection();
                if (selection.size() > 0) {
                    String selected = (String)selection.getFirstElement();
                    MuleProjectExportPage.this.comboFileName.getCombo().setText(selected);
                }
                MuleProjectExportPage.this.updatePageComplete(MuleProjectExportPage.this.muleProject);
            }
        });
        this.comboFileName.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MuleProjectExportPage.this.updatePageComplete(MuleProjectExportPage.this.muleProject);
            }
        });
        this.browseButton = new Button((Composite)exportGroup, 0);
        this.browseButton.setText("...");
        this.browseButton.setLayoutData((Object)new GridData(3));
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MuleProjectExportPage.this.pickFile();
            }
        });
        Composite wrapper = new Composite((Composite)exportGroup, 0);
        this.attachSourcesButton = new Button(wrapper, 32);
        this.attachSourcesButton.setText("Attach project sources");
        this.attachSourcesButton.setToolTipText("Include source files that allows you to re-import project in studio");
        this.attachSourcesButton.setSelection(true);
        Composite onlyComposite = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(onlyComposite);
        GridDataFactory.fillDefaults().indent(16, 0).applyTo((Control)onlyComposite);
        this.onlySources = new Button(onlyComposite, 32);
        this.onlySources.setText("Only export project sources");
        this.onlySources.setToolTipText("The exported jar only include source files that allows you to re-import project in studio");
        this.onlySources.setSelection(false);
        this.includeDependencies = new Button(wrapper, 32);
        this.includeDependencies.setText("Include project modules and dependencies");
        this.includeDependencies.setToolTipText("This elements are required in the package to deploy to Cloudhub.");
        this.includeDependencies.setSelection(true);
        CLabel infoGroupIdImag = new CLabel(wrapper, 0);
        infoGroupIdImag.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        infoGroupIdImag.setText("A lightweight package generated without modules and dependencies won't be\ndeployable to CloudHub but can be imported into Studio.");
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(wrapper);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)wrapper);
        if (this.muleProject != null) {
            this.addLinkedProjectsOptions(exportGroup);
        }
        this.addExportOptionsListener();
        this.setDefaultSettings();
        this.setControl((Control)this.control);
        this.setPageComplete(this.defaultSettingsExist());
    }

    private void addExportOptionsListener() {
        this.onlySources.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.onlySources.getSelection()) {
                this.includeDependencies.setSelection(false);
            }
        }));
        this.includeDependencies.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.includeDependencies.getSelection()) {
                this.onlySources.setSelection(false);
            }
        }));
    }

    protected void addLinkedProjectsOptions(Group exportGroup) {
        IMuleApplicationProject applicationProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(this.muleProject);
        if (UiUtils.usesApiGatewayDefaultDomain((IMuleProject)applicationProject)) {
            this.includeLinkedProjectsButton = this.createIncludeLinkedProjectsButton(exportGroup, "Export parent domain project", "Include the parent domain in this exported package.", false);
            GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.includeLinkedProjectsButton);
        }
    }

    protected void addWarningMessage(Composite composite) {
        if (MuleProjectKind.APPLICATION.classifies(this.muleProject) && !((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(this.muleProject)).hasDefaultDomain()) {
            CLabel label = new CLabel(composite, 0);
            label.setImage(Display.getCurrent().getSystemImage(8));
            label.setText("The project will be exported without its corresponding domain.");
        }
    }

    protected Button createIncludeLinkedProjectsButton(Group exportGroup, String text, String toolTip, boolean checked) {
        Button button = new Button((Composite)exportGroup, 32);
        button.setText(text);
        button.setToolTipText(toolTip);
        button.setSelection(checked);
        return button;
    }

    void createProjectsCombo(Group exportGroup, GridData gd) {
        Label projLabel = new Label((Composite)exportGroup, 0);
        projLabel.setText("Project:");
        projLabel.setLayoutData((Object)gd);
        this.projects = new ComboViewer((Composite)exportGroup, 12);
        GridData projectGridData = new GridData(768);
        projectGridData.grabExcessHorizontalSpace = true;
        projectGridData.horizontalSpan = 2;
        this.projects.getCombo().setLayoutData((Object)projectGridData);
        this.projects.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
        this.projects.setContentProvider((IContentProvider)new MuleContentProvider());
        try {
            this.projects.setInput((Object)MuleRuntime.getMuleRoot());
        }
        catch (CoreException e) {
            MuleUIPlugin.getDefault().logError("Unable to list Mule projects.", e);
        }
        this.projects.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MuleProjectExportPage.this.projects.getSelection();
                if (selection.size() > 0) {
                    IMuleProject selected;
                    MuleProjectExportPage.this.muleProject = selected = (IMuleProject)selection.getFirstElement();
                    MuleProjectExportPage.this.currentWizardSettings = WizardSettings.createProjectScope(MuleProjectExportPage.this.muleProject, MuleProjectExportPage.PROJECT_SETTINGS_FILE_NAME);
                    MuleProjectExportPage.this.comboFileName.setInput((Object)MuleProjectExportPage.this.currentWizardSettings);
                    MuleProjectExportPage.this.setDefaultSettings();
                }
                MuleProjectExportPage.this.updatePageComplete(MuleProjectExportPage.this.muleProject);
            }
        });
    }

    private void setDefaultSettings() {
        if (this.muleProject != null) {
            String[] paths = this.currentWizardSettings.getSavedSettings();
            if (paths.length == 0) {
                String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + this.getName(this.muleProject);
                this.comboFileName.getCombo().setText(filePath);
            } else {
                Object elementAt = this.comboFileName.getElementAt(0);
                if (elementAt != null) {
                    this.comboFileName.setSelection((ISelection)new StructuredSelection(elementAt), true);
                }
            }
        }
    }

    private String getName(IMuleProject muleProject) {
        return MuleProjectKind.DOMAIN.classifies(muleProject) ? DomainUtils.getDeployableArtifactName((IMuleProject)muleProject) : muleProject.getName();
    }

    private boolean defaultSettingsExist() {
        return StringUtils.isNotEmpty((String)this.comboFileName.getCombo().getText()) && this.muleProject != null;
    }

    protected void pickFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFileName(this.getName(this.muleProject));
        String result = dialog.open();
        if (result != null) {
            this.comboFileName.getCombo().setText(result);
        }
    }

    protected String getFileNameSelected() {
        return this.comboFileName.getCombo().getText();
    }

    protected void updatePageComplete(IMuleProject muleProject) {
        boolean complete = true;
        String message = null;
        this.outputAbsolutePath = this.comboFileName.getCombo().getText();
        if (muleProject == null) {
            complete = false;
        } else if (muleProject.getProjectModelState() != ProjectModelState.VALID) {
            message = "The current project has an invalid pom.xml file. Please correct the issues before proceeding.";
            complete = false;
        } else if (StringUtils.isBlank((String)this.outputAbsolutePath)) {
            complete = false;
        } else {
            File outputFile = new File(this.outputAbsolutePath);
            if (outputFile.isDirectory()) {
                message = "Export destination must be a file, not a directory.";
                complete = false;
            } else if (outputFile.getParentFile() == null || !outputFile.getParentFile().exists()) {
                message = "Export destination must be inside an existing path.";
                complete = false;
            }
        }
        this.setErrorMessage(message);
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updatePageComplete(this.muleProject);
    }

    public boolean performFinish() {
        boolean confirmation;
        boolean success;
        this.outputAbsolutePath = this.comboFileName.getCombo().getText();
        File tempFile = new File(this.outputAbsolutePath);
        File folder = tempFile.getParentFile();
        if (!this.saveModifiedResources()) {
            MessageDialog.openError((Shell)WidgetUtils.getShell(), (String)"Mule Project Export", (String)"Export file creation failed. There are unsaved resources in the project.");
            return false;
        }
        if (!folder.exists() && !(success = this.createFolder(folder))) {
            return false;
        }
        File outputFile = this.createOutputFile(this.outputAbsolutePath);
        if (outputFile.exists() && !(confirmation = MessageDialog.openQuestion((Shell)WidgetUtils.getShell(), (String)"Confirmation", (String)(outputFile.getAbsolutePath() + " already exists.\nDo you want to replace it?")))) {
            return false;
        }
        boolean includeLinkedProjects = this.includeLinkedProjectsButton != null ? this.includeLinkedProjectsButton.getSelection() : true;
        long startTime = System.currentTimeMillis();
        boolean exportProject = this.exportProject(outputFile, this.attachSourcesButton.getSelection(), !this.includeDependencies.getSelection(), includeLinkedProjects, this.onlySources.getSelection());
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        if (exportProject) {
            this.trackExportPackageMetric(Events.EXPORT_DEPLOYABLE_PROJECT, elapsedTime);
        } else {
            this.trackExportPackageMetric(Events.FAILED_EXPORT_DEPLOYABLE_PROJECT, elapsedTime);
        }
        return exportProject;
    }

    private void trackExportPackageMetric(String metricId, long elapsedTime) {
        AnalyticsRecordsFactory.single((String)metricId, (String[])new String[]{"outputLocation", this.outputAbsolutePath, "lightPackage", String.valueOf(!this.includeDependencies.getSelection()), "exportTimeMillis", String.valueOf(elapsedTime)}).track();
    }

    private boolean saveModifiedResources() {
        List<IEditorPart> dirtyEditors = UiUtils.getDirtyEditors(this.muleProject.getProject());
        if (dirtyEditors.isEmpty()) {
            return true;
        }
        SaveModifiedResourcesDialog dialog = new SaveModifiedResourcesDialog(WidgetUtils.getShell());
        return dialog.open(this.getContainer().getShell(), dirtyEditors);
    }

    private boolean createFolder(File folder) {
        boolean confirmation = MessageDialog.openQuestion((Shell)WidgetUtils.getShell(), (String)"Confirmation", (String)("Directory " + folder.getAbsolutePath() + " does not exist.\nDo you want to create it?"));
        if (confirmation) {
            boolean success = folder.mkdirs();
            if (!success) {
                MessageDialog.openError((Shell)WidgetUtils.getShell(), (String)"Problem Ocurred", (String)("Could not create directory " + folder.getAbsolutePath()));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean exportProject(File outputFile, boolean attachSources, boolean lightPackage, boolean exportParentDomain, boolean onlySources) {
        boolean shouldExport;
        this.currentWizardSettings.saveSettings(this.comboFileName.getCombo().getText());
        if (CoreUtils.hasMuleErrors((IMuleProject)this.muleProject) && !(shouldExport = MessageDialog.openQuestion((Shell)WidgetUtils.getShell(), (String)"Project Export", (String)"Current project contains errors.\nProceed with export?"))) {
            return false;
        }
        MuleExportRunnable runnable = null;
        try {
            runnable = this.runExportProject(runnable, outputFile, attachSources, lightPackage, exportParentDomain, onlySources, true);
            if (!runnable.wasSuccessfulExport()) {
                return false;
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            this.openExportError(outputFile);
            return false;
        }
        Optional resultFile = runnable.getResultFile();
        if (resultFile.isPresent() && ((File)resultFile.get()).exists()) {
            String absolutePath = ((File)resultFile.get()).getAbsolutePath();
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getShell().getText(), (String)("Project exported successfully at " + absolutePath));
            return true;
        }
        this.openExportError(outputFile);
        return false;
    }

    public MuleExportRunnable runExportProject(MuleExportRunnable runnable, File outputFile, boolean attachSources, boolean lightPackage, boolean exportParentDomain, boolean onlySources, boolean retry) throws InvocationTargetException, InterruptedException {
        runnable = new MuleExportRunnable(this.muleProject, outputFile, attachSources, lightPackage, exportParentDomain, onlySources);
        this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
        if (!runnable.wasSuccessfulExport()) {
            if (retry) {
                int result;
                MuleExportStatus exportStatus = runnable.getExportStatus();
                if (MuleExportStatus.MuleExportResult.EXPORT_ERROR.equals((Object)exportStatus.getResult()) && (result = ErrorActionDialog.openError((Shell)this.getShell(), (String)"Export error", (String)"The build process had some errors. Proceed with export anyway?", (String)("Unable to generate archive" + exportStatus.getErrorMessage()))) == 0) {
                    runnable = this.runExportProject(runnable, outputFile, attachSources, false, exportParentDomain, true, false);
                }
            } else {
                this.openExportError(outputFile);
            }
        }
        return runnable;
    }

    private void openExportError(File outputFile) {
        MessageDialogUtils.openErrorWithLinkToLogView(this.getShell(), "Error while exporting", "Unable to generate archive. Expected output file " + outputFile.getAbsolutePath() + " does not exist.");
    }

    private File createOutputFile(String outputFilePath) {
        Object fileName = outputFilePath.endsWith(".jar") ? outputFilePath : outputFilePath + ".jar";
        return new File((String)fileName);
    }

    public String getExportDescription() {
        return EXPORT_DESCRIPTION;
    }

    public String getExportTitle() {
        return EXPORT_TITLE;
    }
}

