/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.wizards.MuleProjectExportPage;

public class MuleDomainProjectExportPage
extends MuleProjectExportPage {
    private static final String DOMAIN_EXPORT_WARNING = "The domain project will be exported without any application linked or attached.";
    private static final String DOMAIN_FILE_NAME_WARNING = "If the file name of the deployable archive is changed, be aware that references to it in a standalone execution environment could fail.";
    private static final String EXPORT_DESCRIPTION = "Export a Mule Domain project as a deployable archive.";
    private static final String EXPORT_TITLE = "Export Mule Domain Project";

    protected MuleDomainProjectExportPage(IMuleProject muleProject) {
        super(muleProject);
    }

    @Override
    protected void addWarningMessage(Composite composite) {
        CLabel label = new CLabel(composite, 0);
        label.setImage(Display.getCurrent().getSystemImage(2));
        label.setText(DOMAIN_EXPORT_WARNING);
    }

    @Override
    public String getExportDescription() {
        return EXPORT_DESCRIPTION;
    }

    @Override
    public String getExportTitle() {
        return EXPORT_TITLE;
    }

    @Override
    protected void updatePageComplete(IMuleProject muleProject) {
        super.updatePageComplete(muleProject);
        if (!this.getFileNameSelected().endsWith(DomainUtils.getDeployableArtifactName((IMuleProject)muleProject))) {
            this.setMessage(DOMAIN_FILE_NAME_WARNING, 2);
        } else {
            this.setMessage(null, 2);
        }
    }

    @Override
    protected void addLinkedProjectsOptions(Group group) {
    }
}

