/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.wizards;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.jface.MuleContentProvider;
import org.mule.tooling.ui.jface.MuleLabelProvider;

public class MuleConfigurationGeneralPage
extends WizardPage {
    private static final String PAGE_DESCRIPTION = "Create and configure a new Mule configuration file.";
    private static final String PAGE_TITLE = "Create a new Mule Configuration File";
    public static final String PAGE_ID = "messageFlowWizardPage";
    public static final String DESCRIPTION = "Create a new Mule Configuration File";
    public static final String NAME_GROUP_HEADER = "General Information";
    protected IMuleProject muleProject;
    protected ComboViewer projectsCombo;
    protected Text textFilename;

    public MuleConfigurationGeneralPage(IMuleProject muleProject) {
        super(PAGE_ID, "Create a new Mule Configuration File", null);
        this.muleProject = muleProject;
        this.setTitle("Create a new Mule Configuration File");
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Group nameGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setText(NAME_GROUP_HEADER);
        ModifyListener pageCompleteListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MuleConfigurationGeneralPage.this.updatePageComplete();
            }
        };
        if (this.muleProject == null) {
            Label projLabel = new Label((Composite)nameGroup, 0);
            projLabel.setText("Project:");
            this.projectsCombo = new ComboViewer((Composite)nameGroup, 12);
            this.projectsCombo.getCombo().setLayoutData((Object)new GridData(768));
            this.projectsCombo.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
            this.projectsCombo.setContentProvider((IContentProvider)new MuleContentProvider());
            this.projectsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MuleConfigurationGeneralPage.this.updateFields(MuleConfigurationGeneralPage.this.getMuleProject());
                    MuleConfigurationGeneralPage.this.updatePageComplete();
                }
            });
            try {
                this.projectsCombo.setInput((Object)MuleRuntime.getMuleRoot());
            }
            catch (CoreException e) {
                MuleUIPlugin.getDefault().logError("Unable to list Mule projects.", e);
            }
        }
        Label filenameLabel = new Label((Composite)nameGroup, 0);
        filenameLabel.setText("File name:");
        this.textFilename = new Text((Composite)nameGroup, 2048);
        this.textFilename.setLayoutData((Object)new GridData(768));
        this.textFilename.addModifyListener(pageCompleteListener);
        this.updateFields(this.getMuleProject());
        this.setControl((Control)nameGroup);
        this.updatePageComplete();
    }

    private void updateFields(IMuleProject muleProject) {
        if (muleProject != null) {
            if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
                this.textFilename.setText("mule-domain-config.xml");
                this.textFilename.setEnabled(false);
            } else {
                this.textFilename.setText("");
                this.textFilename.setEnabled(true);
            }
        }
    }

    protected void updatePageComplete() {
        boolean complete = true;
        this.setErrorMessage(null);
        if (this.getMuleProject() == null && this.projectsCombo.getSelection().isEmpty()) {
            complete = false;
        } else if (this.textFilename.getText().length() == 0) {
            complete = false;
        } else if (this.getMuleProject() != null && this.isAlreadyExistingConfiguration()) {
            this.setErrorMessage("A configuration with the selected name exists within the project.");
            complete = false;
        }
        this.setPageComplete(complete);
    }

    private boolean isAlreadyExistingConfiguration() {
        if (this.hasTextFileNameMuelConfigExtension()) {
            return this.getTargetFolder().findMember(this.textFilename.getText()) != null;
        }
        return this.getTargetFolder().findMember(this.getFileNameWithMuleConfigExtension()) != null;
    }

    public IMuleProject getMuleProject() {
        if (this.muleProject != null) {
            return this.muleProject;
        }
        IStructuredSelection sel = (IStructuredSelection)this.projectsCombo.getSelection();
        return (IMuleProject)sel.getFirstElement();
    }

    public String getMuleConfigurationFilename() {
        if (!this.hasTextFileNameMuelConfigExtension()) {
            return this.getFileNameWithMuleConfigExtension();
        }
        return this.textFilename.getText();
    }

    private boolean hasTextFileNameMuelConfigExtension() {
        return this.textFilename.getText().endsWith(".xml");
    }

    private String getFileNameWithMuleConfigExtension() {
        return this.textFilename.getText() + ".xml";
    }

    public IFolder getTargetFolder() {
        return this.getMuleProject().getMuleAppsFolder();
    }
}

