/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.ui.utils.GrayedTooltipTextListener;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public final class UiUtils {
    private UiUtils() {
    }

    public static <T> T openEditorForFile(IFile file, String id) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)id, (boolean)true);
        editorPart.setFocus();
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
        return (T)editorPart;
    }

    public static IEditorPart openEditorForFile(IFile file) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        editorPart.setFocus();
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
        return editorPart;
    }

    public static void openTextEditorForFile(IFile file) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.ui.DefaultTextEditor", (boolean)true);
    }

    public static void showFirstFlowInProject(final String projectName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IFile muleConfigurationXmlFile;
                    IProject project;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    if (root != null && !StringUtils.isEmpty((String)projectName) && (project = root.getProject(projectName)) != null && (muleConfigurationXmlFile = UiUtils.getFirstConfigurationFile(project)) != null) {
                        UiUtils.openEditorForFile(muleConfigurationXmlFile);
                    }
                }
                catch (CoreException e) {
                    Throwable cause = e.getCause();
                    MessageDialog.openError(null, (String)"Error", (String)("Problem opening flow file.\n" + (cause != null ? cause.getMessage() : e.getMessage())));
                }
            }
        });
    }

    private static IFile getFirstConfigurationFile(IProject project) throws CoreException {
        IMuleProject createdMuleProject = MuleRuntime.create((IProject)project);
        List configurationResources = createdMuleProject.getConfigurationsCache().getConfigurationResources();
        IResource[] muleAppsFolderMembers = createdMuleProject.getMuleAppsFolder().members();
        ArrayList<IFile> muleAppsConfigs = new ArrayList<IFile>();
        IResource[] iResourceArray = muleAppsFolderMembers;
        int n = muleAppsFolderMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (configurationResources.contains(member) && member instanceof IFile) {
                muleAppsConfigs.add((IFile)member);
            }
            ++n2;
        }
        if (muleAppsConfigs.isEmpty()) {
            if (configurationResources.isEmpty()) {
                return null;
            }
            Collections.sort(configurationResources, UiUtils.getResourceNameComparator());
            return (IFile)configurationResources.get(0);
        }
        Collections.sort(muleAppsConfigs, UiUtils.getResourceNameComparator());
        IFile muleConfigurationXmlFile = (IFile)muleAppsConfigs.get(0);
        return muleConfigurationXmlFile;
    }

    private static Comparator<? super IFile> getResourceNameComparator() {
        return new Comparator<IFile>(){

            @Override
            public int compare(IFile file, IFile otherfile) {
                return file.getName().compareTo(otherfile.getName());
            }
        };
    }

    public static List<IEditorPart> getDirtyEditors(IProject project) {
        IWorkbenchWindow[] windows;
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart ep = iEditorPartArray[n6];
                    IEditorInput input = ep.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFileEditorInput fileInput = (IFileEditorInput)input;
                        IFile file = fileInput.getFile();
                        if (project == null || file.getProject() == project) {
                            result.add(ep);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public static void showConsoleView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.showView("org.eclipse.ui.console.ConsoleView", null, 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static MessageConsole getMessageConsole(String consoleName) {
        return UiUtils.getMessageConsole(consoleName, null);
    }

    public static MessageConsole getMessageConsole(String consoleName, ImageDescriptor imageDescriptor) {
        IConsole targetConsole = null;
        targetConsole = UiUtils.searchForExistingConsole(consoleName);
        if (targetConsole == null) {
            targetConsole = new MessageConsole(consoleName, imageDescriptor);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{(MessageConsole)targetConsole});
        }
        return (MessageConsole)targetConsole;
    }

    private static IConsole searchForExistingConsole(String consoleName) {
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        IConsole targetConsole = null;
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(consoleName)) {
                targetConsole = console;
            }
            ++n2;
        }
        return targetConsole;
    }

    public static IMuleProject getSelectedMuleProjectInPackageExplorer() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection("org.eclipse.jdt.ui.PackageExplorer");
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return UiUtils.getMuleProjectFromPackageExplorerSelection(selection);
    }

    private static IMuleProject getMuleProjectFromPackageExplorerSelection(ISelection selection) {
        IMuleProject muleProject = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection treeSelection = (IStructuredSelection)selection;
            Object element = treeSelection.getFirstElement();
            if (element instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)element;
                element = javaElement.getJavaProject().getProject();
            } else if (element instanceof ClassPathContainer) {
                element = ((ClassPathContainer)element).getJavaProject().getProject();
            } else if (element instanceof JarPackageFragmentRoot) {
                element = ((JarPackageFragmentRoot)element).getJavaProject().getProject();
            } else if (element instanceof JarEntryFile) {
                element = ((JarEntryFile)element).getPackageFragmentRoot().getJavaProject().getProject();
            }
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                muleProject = MuleRuntime.create((IProject)resource.getProject());
            }
        }
        return muleProject;
    }

    public static void addFilterToViewer(StructuredViewer viewer, ViewerFilter filter) {
        ArrayList<ViewerFilter> filtersAsList = new ArrayList<ViewerFilter>(Arrays.asList(viewer.getFilters()));
        filtersAsList.add(filter);
        viewer.setFilters(filtersAsList.toArray(new ViewerFilter[filtersAsList.size()]));
    }

    public static Group createGroupWithTitle(Composite container, String title, int columns) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        group.setLayout((Layout)layout);
        group.setText(title);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)group);
        return group;
    }

    public static RGB parseRGBString(String rgbString) {
        RGB parsedRGB = null;
        String[] rgbElements = rgbString.split(",");
        if (rgbElements.length == 3) {
            parsedRGB = new RGB(Integer.parseInt(rgbElements[0].trim()), Integer.parseInt(rgbElements[1].trim()), Integer.parseInt(rgbElements[2].trim()));
        }
        return parsedRGB;
    }

    public static void disposeComposite(Composite composite) {
        if (!composite.isDisposed()) {
            UiUtils.disposeAll(composite.getChildren());
            if (!composite.isDisposed()) {
                composite.dispose();
            }
        }
    }

    public static void disposeAll(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
    }

    public static void addGrayedTooltipWhenEmpty(Text text, String string) {
        GrayedTooltipTextListener grayedTooltipListener = new GrayedTooltipTextListener(text, string);
        text.addFocusListener((FocusListener)grayedTooltipListener);
        text.addModifyListener((ModifyListener)grayedTooltipListener);
        grayedTooltipListener.initialize();
    }

    public static boolean usesApiGatewayDefaultDomain(IMuleProject muleProject) {
        if (!MuleProjectKind.APPLICATION.classifies(muleProject)) {
            return false;
        }
        IMuleApplicationProject appProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject);
        IServerDefinition serverDefinition = muleProject.getServerDefinition();
        return "api-gateway".equals(appProject.getDomainName()) && ServerMatcher.fromString((String)"gateway[2.0,8.0]").matches(serverDefinition);
    }

    public static Composite createDisabledComposite(Composite parent, String message, Image image) {
        Composite composite = new Composite(parent, 0);
        ThemeUtils.setCssClass((Object)composite, (String)"disabled-page");
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite centeredComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(centeredComposite);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)centeredComposite);
        Label imageLabel = new Label(centeredComposite, 0x1000000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)imageLabel);
        imageLabel.setImage(image);
        CLabel messageLabel = new CLabel(centeredComposite, 0x1000000);
        ThemeUtils.setCssClass((Object)messageLabel, (String)"disabled-page-label");
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)messageLabel);
        messageLabel.setText(message);
        return composite;
    }

    public static Composite createPaletteDropAreaComposite(Composite parent, String message, Image image) {
        Composite composite = new Composite(parent, 0);
        ThemeUtils.setCssClass((Object)composite, (String)"drop-area-page");
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite centeredComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(centeredComposite);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)centeredComposite);
        ThemeUtils.setCssClass((Object)centeredComposite, (String)"drop-area-page-composite");
        Label imageLabel = new Label(centeredComposite, 0x1000000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)imageLabel);
        imageLabel.setImage(image);
        ThemeUtils.setCssClass((Object)imageLabel, (String)"drop-area-page-image");
        CLabel messageLabel = new CLabel(centeredComposite, 0x1000000);
        ThemeUtils.setCssClass((Object)messageLabel, (String)"drop-area-page-label");
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)messageLabel);
        messageLabel.setText(message);
        return composite;
    }

    public static int openError(Shell parent, String title, String message, Throwable t) {
        MultiStatus status = UiUtils.createMultiStatus(t.getLocalizedMessage(), t);
        return ErrorDialog.openError((Shell)parent, (String)title, (String)message, (IStatus)status);
    }

    private static MultiStatus createMultiStatus(String reason, Throwable t) {
        StackTraceElement[] stackTraces;
        ArrayList<Status> statuses = new ArrayList<Status>();
        StackTraceElement[] stackTraceElementArray = stackTraces = t.getStackTrace();
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTrace = stackTraceElementArray[n2];
            Status status = new Status(4, "PluginId", stackTrace.toString());
            statuses.add(status);
            ++n2;
        }
        MultiStatus ms = new MultiStatus("PluginId", 4, (IStatus[])statuses.toArray(new Status[0]), reason, t);
        return ms;
    }
}

