/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.utils;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class GrayedTooltipTextListener
implements FocusListener,
ModifyListener {
    private Text text;
    private String tooltip;
    private TooltipState tooltipState;

    public GrayedTooltipTextListener(Text text, String tooltip) {
        this.text = text;
        this.tooltip = tooltip;
    }

    public void initialize() {
        String currentText = this.text.getText();
        if (currentText.trim().isEmpty()) {
            this.updateState(TooltipState.SHOWING);
        } else {
            this.updateState(TooltipState.NOT_SET);
        }
    }

    private void updateState(TooltipState newState) {
        this.tooltipState = newState;
        this.tooltipState.apply(this.text, this.tooltip);
    }

    public static Color getActiveColor() {
        return GrayedTooltipTextListener.getDisplay().getSystemColor(2);
    }

    public static Color getInactiveColor() {
        return GrayedTooltipTextListener.getDisplay().getSystemColor(16);
    }

    public void focusGained(FocusEvent e) {
        if (this.tooltipState.equals((Object)TooltipState.VISIBLE)) {
            this.updateState(TooltipState.HIDING);
        }
    }

    public void focusLost(FocusEvent e) {
        String currentText = this.text.getText();
        if (this.tooltipState.equals((Object)TooltipState.HIDDEN) || this.tooltipState.equals((Object)TooltipState.NOT_SET) && currentText.isEmpty()) {
            this.updateState(TooltipState.SHOWING);
        }
    }

    public void modifyText(ModifyEvent e) {
        String currentText = this.text.getText();
        if (this.tooltipState.equals((Object)TooltipState.SHOWING)) {
            this.updateState(TooltipState.VISIBLE);
        } else if (this.tooltipState.equals((Object)TooltipState.HIDING) && currentText.isEmpty()) {
            this.updateState(TooltipState.HIDDEN);
        } else if (this.tooltipState.equals((Object)TooltipState.VISIBLE) && currentText.isEmpty()) {
            this.updateState(TooltipState.SHOWING);
        } else if (!currentText.isEmpty()) {
            this.updateState(TooltipState.NOT_SET);
        }
    }

    private static Display getDisplay() {
        Display current = Display.getCurrent();
        return current != null ? current : Display.getDefault();
    }

    private static enum TooltipState {
        NOT_SET,
        SHOWING,
        VISIBLE,
        HIDING,
        HIDDEN;


        private void apply(Text text, String tooltip) {
            switch (this) {
                case NOT_SET: {
                    text.setForeground(GrayedTooltipTextListener.getActiveColor());
                    break;
                }
                case HIDING: {
                    text.setText("");
                    text.setForeground(GrayedTooltipTextListener.getActiveColor());
                    break;
                }
                case SHOWING: {
                    text.setText(tooltip);
                    text.setForeground(GrayedTooltipTextListener.getInactiveColor());
                }
            }
        }
    }
}

