/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Display;

public class DelayedRunnableScheduler {
    private final int defaultDelayInMillis;
    private AtomicReference<Request> lastRequest = new AtomicReference();

    public DelayedRunnableScheduler(int delayInMillis) {
        this.defaultDelayInMillis = delayInMillis;
    }

    public DelayedRunnableScheduler() {
        this(500);
    }

    public void schedule(Runnable toSchedule) {
        this.schedule(toSchedule, this.defaultDelayInMillis);
    }

    public void schedule(Runnable toSchedule, int delayInMillis) {
        Request newRequest = new Request(toSchedule);
        this.lastRequest.set(newRequest);
        Display display = Display.getCurrent();
        if (display != null) {
            Runnable dispatcher = () -> {
                if (this.lastRequest.get() == newRequest) {
                    request.toRun.run();
                    this.lastRequest.set(null);
                }
            };
            display.timerExec(delayInMillis, dispatcher);
        }
    }

    public boolean hasSchedules() {
        return this.lastRequest.get() != null;
    }

    private static class Request {
        private Runnable toRun;

        public Request(Runnable toRun) {
            this.toRun = toRun;
        }
    }
}

