/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.utils;

import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class ControlFactory {
    private final Composite parent;

    public static ControlFactory createChildsOf(Composite parent) {
        return new ControlFactory(parent);
    }

    public ControlFactory(Composite parent) {
        this.parent = parent;
    }

    public Label label(String text) {
        Label label = new Label(this.parent, 0);
        label.setText(text);
        return label;
    }

    public Combo dropdown(List<String> items) {
        return this.dropdown(null, items.toArray(new String[items.size()]));
    }

    public Combo dropdown(List<String> items, SelectionListener listener) {
        return this.dropdown(listener, items.toArray(new String[items.size()]));
    }

    public Combo dropdown(SelectionListener listener, String ... items) {
        Combo combo = new Combo(this.parent, 8);
        combo.setItems(items);
        combo.select(0);
        if (listener != null) {
            combo.addSelectionListener(listener);
        }
        return combo;
    }

    public Composite composite() {
        return new Composite(this.parent, 0);
    }

    public Composite composite(Layout layout) {
        Composite composite = this.composite();
        composite.setLayout(layout);
        return composite;
    }

    public Spinner spinner() {
        return new Spinner(this.parent, 0);
    }

    public Button radio(String text) {
        return this.radio(text, null);
    }

    public StyledText styledText() {
        return this.styledText(2306);
    }

    public StyledText styledTextSingleLine(SelectionListener listener) {
        return this.styledText(2052, listener);
    }

    public StyledText styledText(int style) {
        return this.styledText(style, null);
    }

    public StyledText styledText(int style, SelectionListener listener) {
        StyledText styledText = new StyledText(this.parent, style);
        if (listener != null) {
            styledText.addSelectionListener(listener);
        }
        return styledText;
    }

    public Button radio(String text, SelectionListener listener) {
        return this.button(text, 16, listener);
    }

    public Button check(String text) {
        return this.check(text, null);
    }

    public Button check(String text, SelectionListener listener) {
        return this.button(text, 32, listener);
    }

    public Button button(String text, int style, SelectionListener listener) {
        Button button = new Button(this.parent, style);
        button.setText(text);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }
}

