/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.security;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MessageDialogWithLink;

public class SecureStorageErrorStatusHandler
implements IStatusHandler {
    private static boolean ALREADY_TRIGGERED = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        SecureStorageErrorStatusHandler secureStorageErrorStatusHandler = this;
        synchronized (secureStorageErrorStatusHandler) {
            block4: {
                if (!ALREADY_TRIGGERED) break block4;
                return null;
            }
            ALREADY_TRIGGERED = true;
        }
        this.scheduleToRunAsJob(monitor -> {
            this.trackSecureStorageError(status.getException());
            this.showSecureStorageError();
        });
        return null;
    }

    private void trackSecureStorageError(Throwable exception) {
        String failureType = this.getFailureType(exception);
        AnalyticsRecordsFactory.single((String)Events.SECURE_STORAGE_FAILED).addMetadata("secureStorageFailureType", failureType).track();
    }

    private String getFailureType(Throwable exception) {
        String errorMessage = exception.getMessage();
        if (errorMessage.contains("No password provided")) {
            return "decryption";
        }
        if (errorMessage.contains("Given final block not properly padded")) {
            return "corrupted";
        }
        if (errorMessage.contains("Secure storage was unable to retrieve the master password")) {
            return "providerAccess";
        }
        return "unknown";
    }

    private void showSecureStorageError() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = SecureStorageErrorStatusHandler.getShell();
                if (shell != null) {
                    URI secureStorageLocation = CoreUtils.getLoginManager().getSecureStorageFileLocation();
                    MessageDialogWithLink dialog = new MessageDialogWithLink(shell, "Secure Storage error", null, "An error with the Secure Storage has been detected.\nAny further action that needs a logged in user will not work as expected.\n\nPlease close all the Anypoint Studio instances and delete/move the following file:\n<a href=\"secureStorageLocation\">" + secureStorageLocation.getPath() + "</a>\n\nFor additional details see: <a href=\"secureStorageDocumentation\">https://docs.mulesoft.com/studio/latest/secure-storage</a>", 1, 0, IDialogConstants.OK_LABEL);
                    dialog.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
                        try {
                            switch (event.text) {
                                case "secureStorageLocation": {
                                    Program.launch((String)secureStorageLocation.resolve(".").getPath());
                                    break;
                                }
                                case "secureStorageDocumentation": {
                                    Program.launch((String)"https://docs.mulesoft.com/studio/latest/secure-storage");
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            MuleCorePlugin.logError((String)"An error ocurred while opening the link", (Throwable)e);
                        }
                    }));
                    dialog.open();
                }
            }
        });
    }

    private void scheduleToRunAsJob(final ICoreRunnable runnable) {
        Job job = new Job("Secure Storage error detected"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (SecureStorageErrorStatusHandler.this.isStarting()) {
                    this.schedule(500L);
                    return Status.OK_STATUS;
                }
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    IStatus st = e.getStatus();
                    return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    private static Shell getShell() {
        if (SecureStorageErrorStatusHandler.runningUI()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                return window.getShell();
            }
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        }
        return null;
    }

    private static boolean runningUI() {
        return PlatformUI.isWorkbenchRunning();
    }

    private boolean isStarting() {
        Shell shell = SecureStorageErrorStatusHandler.getShell();
        return shell == null;
    }
}

