/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.project.MuleExtension;

public class RemoveConflictingMuleExtension
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            String attribute = marker.getAttribute("pomErrorKind", "other");
            if (attribute.equals("conflictingExtension")) {
                String extensionName = this.getStringAttribute(marker, "conflictingMuleExtensionName");
                MuleExtension extension = new MuleExtension(extensionName, extensionName, this.getStringAttribute(marker, "conflictingMuleExtensionScope"));
                IMuleProject project = MuleRuntime.create((IProject)marker.getResource().getProject());
                return new IMarkerResolution[]{new RemoveConflicingMuleExtensionResolution(extension, project)};
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error while executing quick fix to remove mule extension", (Throwable)e);
        }
        return new IMarkerResolution[0];
    }

    private String getStringAttribute(IMarker marker, String name) throws CoreException {
        return (String)marker.getAttribute(name);
    }

    private static class RemoveConflicingMuleExtensionResolution
    implements IMarkerResolution {
        private final MuleExtension extension;
        private final IMuleProject project;

        public RemoveConflicingMuleExtensionResolution(MuleExtension extension, IMuleProject project) {
            this.extension = extension;
            this.project = project;
        }

        public String getLabel() {
            return "Remove extension " + this.extension.getName() + " from project";
        }

        public void run(IMarker marker) {
            this.project.getMuleProjectModel().removeMuleExtension(this.extension);
        }
    }
}

