/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.internal;

import java.util.HashMap;
import java.util.HashSet;
import org.mule.tooling.core.module.ExternalContributionMuleModule;

public class ModulesByGA {
    private String groupid;
    private String artifactid;
    private String selectedVersion;
    private String customVersion = null;
    private String name;
    private ExternalContributionMuleModule originalModule;
    private HashMap<String, String> versionsToDescriptionMap;

    public ModulesByGA(ExternalContributionMuleModule externalContribution) {
        String id = externalContribution.getId();
        this.versionsToDescriptionMap = new HashMap();
        this.name = externalContribution.getName();
        this.groupid = id.split(":")[0];
        this.artifactid = id.split(":")[1];
        this.selectedVersion = this.getVersion(externalContribution);
        this.originalModule = externalContribution;
        this.versionsToDescriptionMap.put(this.selectedVersion, externalContribution.getDescription());
    }

    private String getVersion(ExternalContributionMuleModule externalContribution) {
        return externalContribution.getId().split(":")[2];
    }

    public String getVersion() {
        return this.selectedVersion == null ? this.customVersion : this.selectedVersion;
    }

    public String[] getAvailableversions() {
        HashSet<String> newAvailableVersions = new HashSet<String>();
        newAvailableVersions.addAll(this.versionsToDescriptionMap.keySet());
        if (this.customVersion != null) {
            newAvailableVersions.add(this.customVersion);
        }
        String[] array = newAvailableVersions.toArray(new String[0]);
        return array;
    }

    public String getId() {
        return this.groupid + ":" + this.artifactid;
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String version) {
        if (this.versionsToDescriptionMap.containsKey(version)) {
            this.selectedVersion = version;
        } else {
            this.selectedVersion = null;
            this.customVersion = version;
        }
    }

    public String getDescription() {
        return this.versionsToDescriptionMap.getOrDefault(this.selectedVersion, "");
    }

    public void addAvailableVersion(ExternalContributionMuleModule e) {
        this.versionsToDescriptionMap.put(e.getId().split(":")[2], e.getDescription());
    }

    public ExternalContributionMuleModule getOriginalModule() {
        return this.originalModule;
    }
}

