/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.ExternalModuleMavenDependency;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.properties.internal.DependencyModuleAdapter;
import org.mule.tooling.ui.properties.internal.ModuleSelection;
import org.mule.tooling.utils.collection.ListView;

public class ExternalModuleAdapter
implements ModuleSelection {
    private final ExternalContributionMuleModule module;
    private final MavenCoordinates coordinates;

    public ExternalModuleAdapter(ExternalContributionMuleModule module) {
        this.module = module;
        this.coordinates = module.getCoordinates();
    }

    @Override
    public String getName() {
        return this.module.getLabel();
    }

    @Override
    public String getGav() {
        return MavenUtils.getGAV((MavenCoordinates)this.coordinates);
    }

    @Override
    public List<ModuleSelection> getDependencies() {
        List dependencies = ExternalModuleMavenDependency.from((ExternalContributionMuleModule)this.module).getPomModel().getDependencies();
        if (dependencies != null) {
            IModuleContributionManager moduleContributionManager = MuleCorePlugin.getModuleContributionManager();
            IServerDefinition serverDefinition = MuleCorePlugin.getDesignContext().getMuleProject().getServerDefinition();
            List dependencyAdapters = dependencies.stream().filter(dep -> "mule-plugin".equals(dep.getClassifier())).filter(dep -> moduleContributionManager.getExternalModule(serverDefinition, this.getCoords((Dependency)dep)) == null).map(dep -> new DependencyModuleAdapter((Dependency)dep)).collect(Collectors.toList());
            List moduleAdapters = dependencies.stream().filter(dep -> "mule-plugin".equals(dep.getClassifier())).map(dep -> moduleContributionManager.getExternalModule(serverDefinition, this.getCoords((Dependency)dep))).map(mod -> mod.orElse(null)).filter(mod -> mod != null).map(dep -> new ExternalModuleAdapter((ExternalContributionMuleModule)dep)).collect(Collectors.toList());
            return ListView.of(moduleAdapters, dependencyAdapters);
        }
        return Collections.emptyList();
    }

    private String getCoords(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion();
    }

    @Override
    public String getDescription() {
        return this.module.getDescription();
    }

    public String getGroupId() {
        return this.coordinates.getGroupId();
    }

    public String getArtifactId() {
        return this.coordinates.getArtifactId();
    }

    public String getVersion() {
        return this.coordinates.getVersion();
    }

    public MavenDependency.Scope getScope() {
        return MavenDependency.Scope.COMPILE;
    }

    public Optional<String> getType() {
        return this.coordinates.getType();
    }

    public Optional<String> getSystemPath() {
        return Optional.empty();
    }

    public Optional<Boolean> isOptional() {
        return Optional.empty();
    }

    public Optional<String> getClassifier() {
        return this.coordinates.getClassifier();
    }

    public boolean isSharedDependency() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalModuleAdapter other = (ExternalModuleAdapter)obj;
        return !(this.module == null ? other.module != null : !this.module.equals((Object)other.module));
    }
}

