/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.ui.properties.internal.ModuleSelection;

public class DependencyModuleAdapter
implements ModuleSelection {
    private final Dependency dependency;

    public DependencyModuleAdapter(Dependency dependency) {
        this.dependency = dependency;
    }

    public String getArtifactId() {
        return this.dependency.getArtifactId();
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.dependency.getClassifier());
    }

    public List<String> getExclusions() {
        List exclusions = this.dependency.getExclusions();
        if (exclusions != null) {
            return exclusions.stream().map(exc -> exc.getGroupId() + ":" + exc.getArtifactId()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getGroupId() {
        return this.dependency.getGroupId();
    }

    public MavenDependency.Scope getScope() {
        return MavenDependency.Scope.value((String)this.dependency.getScope());
    }

    public Optional<String> getSystemPath() {
        return Optional.ofNullable(this.dependency.getSystemPath());
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.dependency.getType());
    }

    public String getVersion() {
        return this.dependency.getVersion();
    }

    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.dependency.isOptional());
    }

    @Override
    public String getName() {
        return Arrays.asList(this.dependency.getArtifactId().split("-")).stream().map(StringUtils::capitalize).collect(Collectors.joining(" ")) + " " + this.dependency.getVersion();
    }

    @Override
    public String getGav() {
        return this.dependency.getGroupId() + ":" + this.dependency.getArtifactId() + ":" + this.dependency.getVersion();
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public List<ModuleSelection> getDependencies() {
        return Collections.emptyList();
    }

    public boolean isSharedDependency() {
        return false;
    }
}

