/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.internal;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.ui.properties.internal.ModuleSelection;

public class AssetSelectionAdapter
implements ModuleSelection {
    private final ExchangeAsset asset;
    private String classifierForAdapter;
    private String type;
    private MavenDependency.Scope scope;

    public AssetSelectionAdapter(ExchangeAsset asset, String classifierForAdapter, String type, MavenDependency.Scope scope) {
        this.asset = asset;
        this.classifierForAdapter = classifierForAdapter;
        this.type = type;
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.asset.getName();
    }

    @Override
    public String getGav() {
        return this.asset.getGroupId() + ":" + this.asset.getArtifactId() + ":" + this.asset.getVersion();
    }

    @Override
    public String getDescription() {
        return Optional.ofNullable(this.asset.getDescription()).orElse("");
    }

    public String getGroupId() {
        return this.asset.getGroupId();
    }

    public String getArtifactId() {
        return this.asset.getArtifactId();
    }

    public String getVersion() {
        return this.asset.getVersion();
    }

    @Override
    public List<ModuleSelection> getDependencies() {
        return this.asset.getExtensionDependencies().stream().map(asset -> new AssetSelectionAdapter((ExchangeAsset)asset, this.classifierForAdapter, this.type, this.scope)).collect(Collectors.toList());
    }

    public MavenDependency.Scope getScope() {
        return this.scope;
    }

    public Optional<String> getType() {
        return Optional.of(this.type);
    }

    public Optional<String> getSystemPath() {
        return Optional.empty();
    }

    public Optional<Boolean> isOptional() {
        return Optional.empty();
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifierForAdapter);
    }

    public boolean isSharedDependency() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.asset == null ? 0 : this.asset.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetSelectionAdapter other = (AssetSelectionAdapter)obj;
        return !(this.asset == null ? other.asset != null : !this.asset.equals(other.asset));
    }

    public String getAssetClassifier() {
        return this.asset.getClassifier();
    }
}

