/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.dependencies;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.ui.properties.dependencies.AddDependencyView;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.properties.internal.ModuleSelection;

public class SearchHandler {
    private final String initialSearchTerm;
    private GraphServiceClient.AssetType[] assetTypes;
    private Optional<MavenDependency> dependencyToExclude = Optional.empty();
    private CompletableFuture<Boolean> showAsyncAPIDependencies;

    public SearchHandler(String initialSearchTerm, GraphServiceClient.AssetType ... assetTypes) {
        this(initialSearchTerm, (MavenDependency)null, assetTypes);
    }

    public SearchHandler(String initialSearchTerm, MavenDependency excludeDependency, GraphServiceClient.AssetType ... assetTypes) {
        this.initialSearchTerm = initialSearchTerm;
        this.assetTypes = assetTypes;
        if (excludeDependency != null) {
            this.dependencyToExclude = Optional.of(excludeDependency);
        }
    }

    public String getInitialSearchTerm() {
        return this.initialSearchTerm;
    }

    public Optional<GraphServiceResponse<ExchangeAsset>> search(IProgressMonitor monitor, String text, BiConsumer<Boolean, List<ExchangeAsset>> updateUI) throws ExternalServiceCallException {
        GraphServiceClient exchangeClient = DependencyUtils.getGraphServiceClient();
        monitor.worked(30);
        GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withSearchTerm("*".equals(text) ? "" : text).resultsLimit(250).includeSnapshots(this.shouldIncludeSnapshots()).withAssetTypes(this.assetTypes).filterBySupportedJVM().build();
        GraphServiceResponse newResponse = exchangeClient.search(queryBuilder, Optional.of(monitor));
        monitor.worked(40);
        LinkedList<ExchangeAsset> elements = new LinkedList<ExchangeAsset>();
        if (this.dependencyToExclude.isPresent()) {
            MavenDependency depToExclude = this.dependencyToExclude.get();
            elements.addAll(newResponse.getElements().stream().filter(dep -> !StringUtils.equals((CharSequence)dep.getArtifactId(), (CharSequence)depToExclude.getArtifactId()) || !StringUtils.equals((CharSequence)dep.getGroupId(), (CharSequence)depToExclude.getGroupId())).collect(Collectors.toList()));
        } else {
            elements.addAll(newResponse.getElements());
        }
        updateUI.accept(newResponse.hasMoreElements(), DependencyUtils.filterDeprecated(elements));
        monitor.worked(30);
        return Optional.ofNullable(newResponse);
    }

    protected boolean shouldIncludeSnapshots() {
        return ExchangePreferences.includeSnapshots();
    }

    public void fetchVersions(ModuleSelection module, AddDependencyView.ModuleVersionSelection versionSelection) throws ExternalServiceCallException, InterruptedException {
        GraphServiceClient graphServiceClient = DependencyUtils.getGraphServiceClient();
        GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(module.getGroupId(), module.getArtifactId()).withAssetTypes(this.assetTypes).includeSnapshots(this.shouldIncludeSnapshots()).build();
        GraphServiceResponse searchByCoordinates = graphServiceClient.search(queryBuilder, Optional.empty());
        List assets = searchByCoordinates.getElements();
        versionSelection.setAvailableVersions(DependencyUtils.filterDeprecated(assets));
    }

    public void fetchMoreElements(IProgressMonitor monitor, Optional<GraphServiceResponse<ExchangeAsset>> currentResponse, BiConsumer<Boolean, List<ExchangeAsset>> updateUI) throws ExternalServiceCallException {
        if (currentResponse.isPresent()) {
            monitor.worked(30);
            currentResponse.get().fetchNextElements();
            monitor.worked(40);
            updateUI.accept(currentResponse.get().hasMoreElements(), DependencyUtils.filterDeprecated(currentResponse.get().getElements()));
            monitor.worked(30);
        }
    }
}

