/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.dependencies;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.client.internal.DefaultExchangeAssetDetails;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.ui.authentication.provider.OrganizationProviderImpl;
import org.mule.tooling.ui.authentication.widgets.FetchOrganizationsJob;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.AddDependencyView;
import org.mule.tooling.ui.properties.dependencies.IDependenciesFetcher;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.properties.internal.ExternalModuleAdapter;
import org.mule.tooling.ui.properties.internal.ModuleSelection;

public class DependencyUtils {
    private static final String DEPRECATED_FILTER_KEY = "deprecated";

    public static GraphServiceClient getGraphServiceClient() {
        return GraphServiceClient.create((String)PlatformUrls.getActiveGraphServiceUrl(), DependencyUtils.getAccessToken());
    }

    private static Optional<String> getAccessToken() {
        AuthUser activeAuthUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        return Optional.ofNullable(activeAuthUser).filter(user -> (Boolean)CoreUtils.getLoginManager().isTokenValid(user).getResult()).map(user -> user.getToken());
    }

    public static List<ExchangeAsset> filterDeprecated(List<ExchangeAsset> assets) {
        boolean showDeprecated = ExchangePreferences.getExchangePreferences().getBoolean("show.deprecated.asset", ExchangePreferences.DEPRECATED_PROPERTY_ASSETS_DEFAULT.booleanValue());
        List<Object> finalAssets = assets;
        if (!showDeprecated) {
            finalAssets = assets.stream().filter(a -> !DEPRECATED_FILTER_KEY.equals(a.getStatus())).collect(Collectors.toList());
        }
        return finalAssets;
    }

    public static void scheduleUpdateOrganizationsJob(AuthUser user, final Consumer<List<Organization>> consumer) {
        final FetchOrganizationsJob fetchOrganizationsJob = new FetchOrganizationsJob("Fetching organizations", user, OrganizationProviderImpl.create());
        fetchOrganizationsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    List organizations = fetchOrganizationsJob.getOrganizations();
                    consumer.accept(organizations);
                }
                super.done(event);
            }
        });
        fetchOrganizationsJob.schedule();
    }

    public static ModuleSelection getModuleSeleciton(Object model, WizardDependencyMode<?> wizardMode) {
        ModuleSelection adapter = null;
        if (model instanceof ExchangeAsset) {
            ExchangeAsset exchangeAsset = (ExchangeAsset)model;
            adapter = wizardMode.adapt(exchangeAsset);
        } else if (model instanceof ExternalContributionMuleModule) {
            ExternalContributionMuleModule module = (ExternalContributionMuleModule)model;
            adapter = new ExternalModuleAdapter(module);
        }
        return adapter;
    }

    public static ModuleSelection retrieveModuleDetailedData(ModuleSelection initialModel, WizardDependencyMode<?> wizardMode) {
        ModuleSelection adapter = initialModel;
        GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(initialModel.getGroupId(), initialModel.getArtifactId(), initialModel.getVersion()).includeSnapshots(ExchangePreferences.includeSnapshots()).build();
        try {
            GraphServiceResponse searchByCoordinates = DependencyUtils.getGraphServiceClient().search(queryBuilder, Optional.empty());
            List elements = searchByCoordinates.getElements().stream().filter(r -> r instanceof DefaultExchangeAssetDetails).collect(Collectors.toList());
            if (elements.size() == 1) {
                ExchangeAsset asset = (ExchangeAsset)elements.get(0);
                adapter = wizardMode.adapt(asset);
            } else {
                MuleCorePlugin.logError((String)("Error resolving dependencies, graphQL service retrieved more than one result for asset: " + initialModel.getArtifactId() + ":" + initialModel.getGroupId()));
            }
        }
        catch (ExternalServiceCallException e) {
            MuleCorePlugin.logError((String)("Error while executing graph client for connector " + initialModel.getArtifactId() + ":" + initialModel.getGroupId()), (Throwable)e);
        }
        return adapter;
    }

    public static AddDependencyView.ModuleVersionSelection getModuleVersionSelection(Object model) {
        AddDependencyView.ModuleVersionSelection moduleVersionSelection = null;
        if (model instanceof AddDependencyView.ModuleVersionSelection) {
            moduleVersionSelection = (AddDependencyView.ModuleVersionSelection)model;
        }
        return moduleVersionSelection;
    }

    public static boolean isVersionEditable(Object object) {
        return object instanceof AddDependencyView.ModuleVersionSelection && ((AddDependencyView.ModuleVersionSelection)object).getAvailableVersions().size() > 1;
    }

    public static String getLatestVersion(IDependency dependency) {
        HashSet allVersions = Sets.newHashSet(dependency.getAvailableVersions());
        allVersions.add(dependency.getVersion());
        return allVersions.stream().max(DependencyUtils.getVersionComparator(true)).orElse(dependency.getVersion());
    }

    public static String getLatestVersionWithinMajorVersion(IDependency dependency) {
        String majorPart = dependency.getVersion().split("\\.")[0];
        Set allVersions = dependency.getAvailableVersions().stream().filter(version -> version.split("\\.")[0].equals(majorPart)).collect(Collectors.toSet());
        allVersions.add(dependency.getVersion());
        return allVersions.stream().max(DependencyUtils.getVersionComparator(true)).orElse(dependency.getVersion());
    }

    public static boolean areSameMajor(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return false;
        }
        return version1.split("\\.")[0].equals(version2.split("\\.")[0]);
    }

    public static Comparator<String> getVersionComparator(boolean ascending) {
        return (dependency1, dependency2) -> new ComparableVersion(ascending ? dependency1 : dependency2).compareTo(new ComparableVersion(ascending ? dependency2 : dependency1));
    }

    public static Comparator<String> getVersionComparator() {
        return DependencyUtils.getVersionComparator(false);
    }

    public static MavenDependency.Scope getOriginalScope(IMuleProject muleProject, ExternalContributionMuleModule module) {
        List appModules = muleProject.getModuleManager(EditingScope.APP).getExternalModules();
        List testAndAppModules = muleProject.getModuleManager(EditingScope.TEST).getExternalModules();
        ArrayList onlyTest = new ArrayList(testAndAppModules);
        onlyTest.removeAll(appModules);
        String moduleGA = MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)module.getId()));
        for (ExternalContributionMuleModule testModule : onlyTest) {
            String currentGA = MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)testModule.getId()));
            if (!currentGA.equals(moduleGA)) continue;
            return MavenDependency.Scope.TEST;
        }
        return MavenDependency.Scope.COMPILE;
    }

    public static String getValueInAssetAttributes(Optional<ExchangeAsset> exchangeAsset, String key) {
        if (exchangeAsset.isPresent()) {
            ExchangeAsset assets = exchangeAsset.get();
            for (ExchangeSchema.Attribute atr : assets.getAttributes()) {
                if (atr.getKey() == null || !atr.getKey().equals(key)) continue;
                return atr.getValue() != null ? atr.getValue() : "";
            }
        }
        return "";
    }

    public static class FetchUpdatesThread
    extends Thread
    implements IDependenciesFetcher {
        private static final int PROGRESS_UNIT = 1;
        private Display display;
        private ProgressBar progressBar;
        private Label info;
        private List<IDependency> dependencies;
        private Runnable callback;
        private BiConsumer<ExchangeAsset, IDependency> update;
        private GraphServiceClient.AssetType[] assetTypes;

        public FetchUpdatesThread(Display display, ProgressBar progressBar, Label info, List<IDependency> dependencies, BiConsumer<ExchangeAsset, IDependency> update, Runnable callback, GraphServiceClient.AssetType[] assetTypes) {
            this.display = display;
            this.progressBar = progressBar;
            this.info = info;
            this.dependencies = dependencies;
            this.update = update;
            this.callback = callback;
            this.assetTypes = assetTypes;
        }

        @Override
        public void run() {
            if (this.display.isDisposed()) {
                return;
            }
            int total = this.dependencies.size() * 2;
            this.dependencies.forEach(dependency -> {
                try {
                    try {
                        GraphServiceClient graphServiceClient = DependencyUtils.getGraphServiceClient();
                        GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(dependency.getGroupId(), dependency.getArtifactId()).withAssetTypes(this.assetTypes).includeSnapshots(ExchangePreferences.includeSnapshots()).build();
                        GraphServiceResponse searchByCoordinates = graphServiceClient.search(queryBuilder, Optional.empty());
                        List assets = searchByCoordinates.getElements();
                        this.progress(dependency.getName(), 1, total);
                        DependencyUtils.filterDeprecated(assets).forEach(asset -> {
                            this.update.accept((ExchangeAsset)asset, (IDependency)dependency);
                            dependency.setName(asset.getName());
                        });
                    }
                    catch (ExternalServiceCallException e) {
                        MuleCorePlugin.logInfo((String)("Failed to retrieve exchange asset: " + e.getMessage()));
                        this.progress(dependency.getName(), 1, total);
                    }
                    catch (IllegalStateException illegalStateException) {
                        MuleCorePlugin.logInfo((String)"Failed to retrieve exchange asset: Connection error.");
                        this.progress(dependency.getName(), 1, total);
                    }
                }
                finally {
                    this.progress(dependency.getName(), 1, total);
                }
            });
            this.finish();
        }

        private void finish() {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    callback.run();
                }
            });
        }

        private void progress(final String dependency, final int progress, final int count) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!progressBar.isDisposed()) {
                        progressBar.setSelection(progressBar.getSelection() + progress);
                        progressBar.setMaximum(count);
                    }
                    if (!info.isDisposed()) {
                        info.setText("Fetching alternative versions for dependency " + dependency);
                    }
                }
            });
        }

        @Override
        public void fetchDependencies() {
            this.start();
        }
    }
}

