/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.ui.authentication.widgets.ActiveUserChangeListener;
import org.mule.tooling.ui.authentication.widgets.UserLoginStatusComponent;
import org.mule.tooling.ui.properties.dependencies.AddDependencyView;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.properties.dependencies.SearchHandler;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.properties.internal.AssetSelectionAdapter;
import org.mule.tooling.ui.properties.internal.ModuleSelection;
import org.mule.tooling.utils.FailableWithProgress;

public class AddDependencyWizardPage
extends WizardPage {
    private GraphServiceResponse<ExchangeAsset> currentResponse;
    private boolean searchHasAlreadyBeenDone = false;
    private UserLoginStatusComponent userLoginComponent;
    private AddDependencyView view;
    private ModuleSelection moduleSelection;
    private AddDependencyView.ModuleVersionSelection moduleVersionSelection;
    private SearchHandler searchHandler;
    private WizardDependencyMode<?> wizardMode;

    public AddDependencyWizardPage(String pageName, WizardDependencyMode<?> mode) {
        super(pageName);
        this.wizardMode = mode;
        this.searchHandler = mode.getSearchHandler();
        this.setTitle("Add Dependencies to Project");
        this.setDescription("Search for dependencies in Exchange to add them to the project");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createAccountComposite(composite);
        this.view = new AddDependencyView(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.view);
        this.view.createContent();
        this.initialize();
        this.setControl((Control)composite);
        this.onUserChanged(Optional.ofNullable(this.userLoginComponent.getCurrentUser()));
        this.updatePageEnablement();
    }

    private void initialize() {
        this.view.getSearchComposite().addSearchListener(event -> this.onSearch());
        this.view.getSearchComposite().addSelectionListener(event -> this.onAvailableSelected());
        this.view.getSearchComposite().addShowMoreListener(event -> this.onShowMore());
        this.view.getActionsComposite().onAdd(event -> this.onAvailableAdded());
        this.view.getActionsComposite().onRemove(event -> this.onCheckoutRemoved());
        this.view.getCheckoutComposite().addSelectionListener(event -> this.onCheckoutSelected());
        this.view.getCheckoutComposite().getCheckoutTable().setInput(new ArrayList());
    }

    private void createAccountComposite(Composite parent) {
        this.userLoginComponent = UserLoginStatusComponent.createWithUserSelector((String)"Username", (String)"Add Account", (String)"Add module wizard");
        Composite userLoginComposite = this.userLoginComponent.createControl(parent);
        this.userLoginComponent.addUserChangeListener(new ActiveUserChangeListener(){

            public void userSelected(AuthUser user) {
                AddDependencyWizardPage.this.onUserChanged(Optional.of(user));
            }

            public void tokenExpired() {
                AddDependencyWizardPage.this.onUserChanged(Optional.empty());
            }

            public void notUserSelected() {
                AddDependencyWizardPage.this.onUserChanged(Optional.empty());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)userLoginComposite);
    }

    private void onUserChanged(Optional<AuthUser> user) {
        this.clear();
        if (user.isPresent()) {
            DependencyUtils.scheduleUpdateOrganizationsJob(user.get(), organizations -> {
                if (!this.view.getSearchComposite().isDisposed()) {
                    this.view.getSearchComposite().setOrganizations((List<Organization>)organizations);
                    if (!this.view.getSearchComposite().getResultsTable().getTable().isDisposed()) {
                        Display.getDefault().asyncExec(() -> {
                            this.view.getSearchComposite().getResultsTable().refresh();
                            this.updateSearchTextIfNoQueryHasBeingDoneYet();
                        });
                    }
                }
            });
        }
    }

    private void onSearch() {
        this.setErrorMessage(null);
        String text = this.view.getSearchComposite().getSearchTextField().getText();
        if (text.isEmpty()) {
            this.view.getSearchComposite().getResultsLabelLink().setVisible(false);
            this.view.getSearchComposite().getResultsTable().setInput(Collections.emptyList());
        } else {
            String jobTitle = "Searching for " + text;
            this.runSearchActionInContainer(jobTitle, true, (FailableWithProgress<ExternalServiceCallException>)((FailableWithProgress)monitor -> this.searchHandler.search(monitor, text, (showMore, elements) -> this.updateWithElements((boolean)showMore, (List<ExchangeAsset>)elements)).ifPresent(newResponse -> {
                this.currentResponse = newResponse;
            })));
        }
    }

    private void updateWithElements(boolean labelLinkVisible, List<ExchangeAsset> elements) {
        Display.getDefault().asyncExec(() -> {
            this.view.getSearchComposite().getResultsLabelLink().setVisible(labelLinkVisible);
            this.view.getSearchComposite().getResultsLabelLink().update();
            this.view.getSearchComposite().getResultsTable().setInput((Object)elements);
            if (!elements.isEmpty()) {
                this.view.getSearchComposite().getResultsTable().reveal(elements.get(0));
            }
        });
    }

    private void onAvailableSelected() {
        IStructuredSelection selection = this.view.getSearchComposite().getResultsTable().getStructuredSelection();
        this.moduleSelection = DependencyUtils.getModuleSeleciton(selection.getFirstElement(), this.wizardMode);
        this.updateAddButtonEnablement(this.moduleSelection);
    }

    private void onAvailableAdded() {
        if (this.moduleSelection != null) {
            if (this.moduleSelection instanceof AssetSelectionAdapter) {
                this.moduleSelection = DependencyUtils.retrieveModuleDetailedData(this.moduleSelection, this.wizardMode);
            }
            AddDependencyView.ModuleVersionSelection versionSelection = new AddDependencyView.ModuleVersionSelection(this.moduleSelection, asset -> this.wizardMode.adapt((ExchangeAsset)asset));
            List input = (List)this.view.getCheckoutComposite().getCheckoutTable().getInput();
            input.add(versionSelection);
            this.view.getCheckoutComposite().getCheckoutTable().setInput((Object)input);
            this.runSearchActionInContainer("Fetching alternative versions for " + this.moduleSelection.getName(), false, (FailableWithProgress<ExternalServiceCallException>)((FailableWithProgress)monitor -> this.searchHandler.fetchVersions(this.moduleSelection, versionSelection)));
            this.view.getCheckoutComposite().getCheckoutTable().refresh();
            this.updatePageEnablement();
            this.updateAddButtonEnablement(this.moduleSelection);
        }
    }

    private void onShowMore() {
        this.runSearchActionInContainer("Fetching more search results", true, (FailableWithProgress<ExternalServiceCallException>)((FailableWithProgress)monitor -> this.searchHandler.fetchMoreElements(monitor, Optional.ofNullable(this.currentResponse), (showMore, elements) -> this.updateWithElements((boolean)showMore, (List<ExchangeAsset>)elements))));
    }

    private void onCheckoutSelected() {
        IStructuredSelection selection = this.view.getCheckoutComposite().getCheckoutTable().getStructuredSelection();
        this.moduleVersionSelection = DependencyUtils.getModuleVersionSelection(selection.getFirstElement());
        this.view.getActionsComposite().getRemoveButton().setEnabled(true);
    }

    private void onCheckoutRemoved() {
        if (this.moduleVersionSelection != null) {
            boolean hasSelection;
            List input = (List)this.view.getCheckoutComposite().getCheckoutTable().getInput();
            int index = input.indexOf(this.moduleVersionSelection);
            input.remove(this.moduleVersionSelection);
            this.view.getCheckoutComposite().getCheckoutTable().setInput((Object)input);
            this.view.getCheckoutComposite().getCheckoutTable().refresh();
            this.updatePageEnablement();
            int newIndex = Math.min(index, input.size() - 1);
            boolean bl = hasSelection = newIndex >= 0 && input.get(newIndex) != null;
            if (hasSelection) {
                this.moduleVersionSelection = (AddDependencyView.ModuleVersionSelection)input.get(newIndex);
                this.view.getCheckoutComposite().getCheckoutTable().getTable().select(newIndex);
            } else {
                this.moduleVersionSelection = null;
            }
            this.view.getActionsComposite().getRemoveButton().setEnabled(hasSelection);
        }
    }

    private void clear() {
        this.view.getSearchComposite().getSearchTextField().setText("");
        this.view.getCheckoutComposite().getCheckoutTable().setInput(new ArrayList());
        this.onSearch();
        this.updatePageEnablement();
    }

    private void updateAddButtonEnablement(ModuleSelection selection) {
        this.view.getActionsComposite().getAddButton().setEnabled(selection != null && !this.isInCheckout(selection));
    }

    private void updatePageEnablement() {
        Object checkoutItems = this.view.getCheckoutComposite().getCheckoutTable().getInput();
        this.setPageComplete(!((List)checkoutItems).isEmpty());
    }

    private boolean isInCheckout(ModuleSelection selection) {
        List checkoutModulesSelection = (List)this.view.getCheckoutComposite().getCheckoutTable().getInput();
        return checkoutModulesSelection.stream().anyMatch(mvs -> {
            ModuleSelection selectedModule = mvs.getSelectedModule();
            return selection.getGroupId().equals(selectedModule.getGroupId()) && selection.getArtifactId().equals(selectedModule.getArtifactId());
        });
    }

    public void runSearchActionInContainer(String jobTitle, boolean setMessageOnErrors, FailableWithProgress<ExternalServiceCallException> runnable) {
        try {
            IWizardContainer container = this.getContainer();
            container.run(true, true, monitor -> {
                monitor.beginTask(jobTitle, 100);
                try {
                    try {
                        runnable.run(monitor);
                    }
                    catch (ExternalServiceCallException e) {
                        String message = jobTitle + " failed. " + e.getMessage();
                        if (setMessageOnErrors) {
                            Display.getDefault().asyncExec(() -> this.setErrorMessage(message));
                        }
                        MuleCorePlugin.logError((String)message, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            String message = jobTitle + " failed. Message: " + e.getMessage();
            if (setMessageOnErrors) {
                this.setErrorMessage(message);
            }
            MuleCorePlugin.logError((String)message, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void updateSearchTextIfNoQueryHasBeingDoneYet() {
        if (StringUtils.isNotBlank((String)this.searchHandler.getInitialSearchTerm()) && !this.searchHasAlreadyBeenDone) {
            this.searchHasAlreadyBeenDone = true;
            this.view.getSearchComposite().getSearchTextField().setText(this.searchHandler.getInitialSearchTerm());
        }
    }

    public List<ExchangeAsset> getCurrentSearchResults() {
        return this.view.getSearchComposite().getResultsTable().getInput() == null ? Collections.emptyList() : (List)this.view.getSearchComposite().getResultsTable().getInput();
    }

    public List<ModuleSelection> getSelectedDependencies() {
        List checkoutModulesSelection = (List)this.view.getCheckoutComposite().getCheckoutTable().getInput();
        return checkoutModulesSelection.stream().map(selection -> selection.getSelectedModule()).collect(Collectors.toList());
    }
}

