/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.CancellingProgressMonitor;
import org.mule.tooling.ui.MessageDialogUtils;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardPage;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.properties.internal.ModuleSelection;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.SyncFutureCallback;
import org.mule.tooling.utils.collection.ListView;

public class AddDependencyWizard<T>
extends Wizard {
    public static final String TITLE = "Add Dependencies to Project";
    private AddDependencyWizardPage selectModuleWizardPage;
    private List<T> resultModules;
    private WizardDependencyMode<T> wizardMode;

    public AddDependencyWizard(WizardDependencyMode<T> wizardDependencyMode) {
        this.wizardMode = wizardDependencyMode;
    }

    public static <T> AddDependencyWizard<T> create(WizardDependencyMode<T> wizardDependencyMode) {
        return new AddDependencyWizard<T>(wizardDependencyMode);
    }

    public void addPages() {
        super.addPages();
        this.selectModuleWizardPage = new AddDependencyWizardPage("Add dependency", this.wizardMode);
        this.addPage((IWizardPage)this.selectModuleWizardPage);
        this.setWindowTitle(TITLE);
        this.setNeedsProgressMonitor(true);
        ThemeUtils.setCssId((Object)this.getShell(), (String)"org-mule-tooling-ui-properties-dependencies-AddDependencyWizard");
    }

    public boolean performFinish() {
        this.resultModules = this.selectModuleWizardPage.getSelectedDependencies().stream().map(this::resolveDependency).filter(dep -> dep != null).reduce(Collections.emptyList(), ListView::of);
        return this.resultModules != null && !this.resultModules.isEmpty();
    }

    private List<T> resolveDependency(ModuleSelection selectedDependency) {
        List resultModules = Collections.emptyList();
        String name = selectedDependency.getName();
        CancellingProgressMonitor cancellingMonitor = new CancellingProgressMonitor();
        SyncFutureCallback successCallback = new SyncFutureCallback();
        SyncFutureCallback failureCallback = new SyncFutureCallback();
        try {
            this.getContainer().run(true, true, monitor -> this.syncResolveExtension(selectedDependency, (SyncFutureCallback<Map<MavenDependency, List<Exception>>>)failureCallback, successCallback, cancellingMonitor, monitor));
            Map failureResult = (Map)failureCallback.getResult();
            if (!cancellingMonitor.isCanceled() && failureResult != null && !failureResult.isEmpty()) {
                String errorsMessage = ArtifactResolvingRunnerFactory.getErrorsMessage((Map)failureResult);
                this.openDownloadErrorMessageDialog(name, errorsMessage);
                ArtifactResolvingRunnerFactory.ON_ERROR_LOG.accept(failureResult);
            } else {
                resultModules = (List)successCallback.getResult();
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.openDownloadErrorMessageDialog(name, e.getMessage());
        }
        return resultModules;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncResolveExtension(ModuleSelection dependency, SyncFutureCallback<Map<MavenDependency, List<Exception>>> failureCallback, SyncFutureCallback<List<T>> successCallback, CancellingProgressMonitor cancellingMonitor, IProgressMonitor monitor) {
        monitor.beginTask("Downloading " + dependency.getName(), -1);
        try {
            block10: {
                boolean finished;
                CountDownLatch latch;
                block9: {
                    ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>(1 + dependency.getDependencies().size());
                    if (dependency.getClassifier().isPresent() && ((String)dependency.getClassifier().get()).equals("mule-plugin")) {
                        dependencies.addAll(dependency.getDependencies());
                    }
                    dependencies.add(dependency);
                    latch = new CountDownLatch(1);
                    CallbackAdapter callback = new CallbackAdapter(failureCallback, successCallback, latch);
                    this.wizardMode.getDependencyManager().asyncResolveDependencies(dependencies, callback);
                    finished = false;
                    if (!true) break block9;
                    if (cancellingMonitor.isCanceled()) return;
                    if (finished) break block10;
                }
                do {
                    try {
                        finished = latch.await(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        MuleCorePlugin.logWarning((String)"Unexpected interruption waiting for extension resolution", (Throwable)e);
                        cancellingMonitor.setCanceled(true);
                    }
                    if (monitor.isCanceled()) {
                        cancellingMonitor.setCanceled(true);
                    }
                    if (cancellingMonitor.isCanceled()) return;
                } while (!finished);
            }
            return;
        }
        finally {
            monitor.done();
        }
    }

    private void openDownloadErrorMessageDialog(String name, String errorsMessage) {
        StringBuilder message = new StringBuilder("An error occurred while downloading the " + name);
        message.append(System.lineSeparator());
        message.append(System.lineSeparator());
        message.append(errorsMessage);
        MessageDialogUtils.openErrorWithLinkToLogView(this.getShell(), TITLE, message.toString());
    }

    public List<T> getResultModules() {
        return this.resultModules;
    }

    private final class CallbackAdapter
    implements Callback<List<T>> {
        private final SyncFutureCallback<Map<MavenDependency, List<Exception>>> failureCallback;
        private final SyncFutureCallback<List<T>> successCallback;
        private final CountDownLatch latch;

        private CallbackAdapter(SyncFutureCallback<Map<MavenDependency, List<Exception>>> failureCallback, SyncFutureCallback<List<T>> successCallback, CountDownLatch latch) {
            this.failureCallback = failureCallback;
            this.successCallback = successCallback;
            this.latch = latch;
        }

        public void onSuccess(List<T> result) {
            this.successCallback.onSuccess(result);
        }

        public void onError(Map<MavenDependency, List<Exception>> errors) {
            this.failureCallback.onSuccess(errors);
        }

        public void doFinally() {
            this.latch.countDown();
        }
    }
}

