/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties.dependencies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.auth.RegionUrlResolver;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.ui.properties.ClassifierType;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.properties.internal.AssetSelectionAdapter;
import org.mule.tooling.ui.properties.internal.ModuleSelection;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.search.SearchTextField;
import org.mule.tooling.ui.widgets.table.TypedEditingSupport;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.ui.widgets.util.SearchResultLabelProvider;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class AddDependencyView
extends Composite {
    private static final String SEARCH_TABLE_TITLE = "Available compatible modules";
    private static final String CHECKOUT_TABLE_TITLE = "Selected modules";
    private String searchTitle = "Available compatible modules";
    private String checkoutTitle = "Selected modules";
    private static final String MULESOFT = "MuleSoft";
    private static final String COL_NAME = "Name";
    private static final String COL_VERSION = "Version";
    private static final String COL_LATEST_VERSION = "Latest version";
    private static final String COL_TYPE = "Asset type";
    private static final String COL_PUBLISHER = "Publisher";
    private static final String MULTI_PAGE_RESULTS_LABEL = "<a>Show more results</a>";
    private static final Point INITIAL_MIN_SIZE = new Point(900, 600);
    private SearchComposite searchComposite;
    private ActionsComposite actionsComposite;
    private CheckoutComposite checkoutComposite;

    public AddDependencyView(Composite parent, int style) {
        super(parent, style);
        FormLayoutUtils.setFormLayout((Composite)this);
    }

    public void createContent() {
        this.searchComposite = new SearchComposite(this, 0);
        FormLayoutUtils.attach((Control)this.searchComposite).top(0).left().right(52, 0).bottom();
        this.actionsComposite = new ActionsComposite(this, 0);
        FormLayoutUtils.attach((Control)this.actionsComposite).top().left(52, 0).right(65, 0).bottom();
        this.checkoutComposite = new CheckoutComposite(this, 0);
        int searchTextSizeHeight = this.searchComposite.getSearchTextField().computeSize((int)-1, (int)-1).y;
        FormLayoutUtils.attach((Control)this.checkoutComposite).top(searchTextSizeHeight + 10).bottom(10).leftFrom((Control)this.actionsComposite, 0).right();
    }

    public SearchComposite getSearchComposite() {
        return this.searchComposite;
    }

    public ActionsComposite getActionsComposite() {
        return this.actionsComposite;
    }

    public CheckoutComposite getCheckoutComposite() {
        return this.checkoutComposite;
    }

    public String getSearchTitle() {
        return this.searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }

    public String getCheckoutTitle() {
        return this.checkoutTitle;
    }

    public void setCheckoutTitle(String checkoutTitle) {
        this.checkoutTitle = checkoutTitle;
    }

    public class ActionsComposite
    extends Composite {
        private static final int BORDER = 5;
        private Button addButton;
        private Button removeButton;

        public ActionsComposite(Composite parent, int style) {
            super(parent, style);
            FormLayoutUtils.setFormLayout((Composite)this, (int)5, (int)5);
            this.create();
        }

        private void create() {
            this.addButton = new Button((Composite)this, 8);
            this.addButton.setText("Add >");
            this.addButton.setEnabled(false);
            this.removeButton = new Button((Composite)this, 8);
            this.removeButton.setText("< Remove");
            this.removeButton.setEnabled(false);
            int buttonHeight = this.addButton.computeSize((int)-1, (int)-1).y;
            FormLayoutUtils.attach((Control)this.addButton).top(50, buttonHeight / 2 + 5).left().right();
            FormLayoutUtils.attach((Control)this.removeButton).top(50, -(buttonHeight / 2 + 5)).left().right();
        }

        public void onRemove(Listener selection) {
            this.removeButton.addListener(13, selection);
        }

        public void onAdd(Listener selection) {
            this.addButton.addListener(13, selection);
        }

        public Button getAddButton() {
            return this.addButton;
        }

        public Button getRemoveButton() {
            return this.removeButton;
        }
    }

    public class CheckoutComposite
    extends Composite {
        private TableViewer checkoutTable;

        public CheckoutComposite(Composite parent, int style) {
            super(parent, style);
            FormLayoutUtils.setFormLayout((Composite)this);
            this.create();
        }

        private void create() {
            Label label = WidgetUtils.label((Composite)this, (String)AddDependencyView.CHECKOUT_TABLE_TITLE);
            FormLayoutUtils.attach((Control)label).top().left().right();
            this.checkoutTable = new TableViewer((Composite)this, 68352);
            this.checkoutTable.getTable().setLinesVisible(true);
            this.checkoutTable.getTable().setHeaderVisible(true);
            this.checkoutTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            WidgetUtils.createColumn((TableViewer)this.checkoutTable, (String)AddDependencyView.COL_NAME, element -> {
                if (element instanceof ModuleVersionSelection) {
                    ModuleVersionSelection moduleSelection = (ModuleVersionSelection)element;
                    return moduleSelection.getName();
                }
                return "";
            });
            WidgetUtils.createColumn((TableViewer)this.checkoutTable, (String)AddDependencyView.COL_TYPE, element -> {
                if (element instanceof ModuleVersionSelection) {
                    ModuleVersionSelection moduleSelection = (ModuleVersionSelection)element;
                    return ClassifierType.mapClassifier(moduleSelection.getCurrentClasiffier().orElse(""));
                }
                return "";
            });
            TableViewerColumn versionColumn = WidgetUtils.createColumn((TableViewer)this.checkoutTable, (String)AddDependencyView.COL_VERSION, element -> {
                if (element instanceof ModuleVersionSelection) {
                    ModuleVersionSelection moduleSelection = (ModuleVersionSelection)element;
                    return moduleSelection.getCurrentVersion();
                }
                return "";
            });
            WidgetUtils.addDropDownHint((TableViewer)this.checkoutTable, (int)2, DependencyUtils::isVersionEditable);
            versionColumn.setEditingSupport((EditingSupport)new ModuleVersionSelectionEditingSupport((ColumnViewer)this.checkoutTable));
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
            this.checkoutTable.getTable().setLayout((Layout)layout);
            FormLayoutUtils.attach((Control)this.checkoutTable.getTable()).topFrom((Control)label, 5).left().right().bottom();
        }

        public void addSelectionListener(ISelectionChangedListener listener) {
            this.checkoutTable.addSelectionChangedListener(listener);
        }

        public TableViewer getCheckoutTable() {
            return this.checkoutTable;
        }
    }

    public static class ModuleVersionSelection {
        private final ModuleSelection original;
        private ModuleSelection selectedVersion;
        private List<ExchangeAsset> availableVersions;
        private Function<ExchangeAsset, AssetSelectionAdapter> adapterFunction;

        public ModuleVersionSelection(ModuleSelection original, Function<ExchangeAsset, AssetSelectionAdapter> adapterFunction) {
            this.original = original;
            this.selectedVersion = original;
            this.availableVersions = Collections.emptyList();
            this.adapterFunction = adapterFunction;
        }

        public ModuleSelection getSelectedModule() {
            return this.selectedVersion;
        }

        public void setCurrentVersion(String value) {
            this.selectedVersion = this.availableVersions.stream().filter(asset -> asset.getVersion().equals(value)).map(asset -> this.adapterFunction.apply((ExchangeAsset)asset)).findFirst().orElseThrow(() -> new IllegalArgumentException("version: " + value + ", available: " + String.valueOf(this.availableVersions)));
        }

        public String getCurrentVersion() {
            return this.selectedVersion.getVersion();
        }

        public Optional<String> getCurrentClasiffier() {
            return Optional.ofNullable(this.selectedVersion).map(asset -> ((AssetSelectionAdapter)asset).getAssetClassifier());
        }

        public String getName() {
            return this.original.getName();
        }

        public void setAvailableVersions(List<ExchangeAsset> list) {
            this.availableVersions = list;
        }

        public List<String> getAvailableVersions() {
            return this.availableVersions.stream().map(asset -> asset.getVersion()).collect(Collectors.toList());
        }

        public String toString() {
            return "ModuleVersionSelection [original=" + String.valueOf(this.original) + ", selectedVersion=" + String.valueOf(this.selectedVersion) + ", availableVersions=" + String.valueOf(this.availableVersions) + "]";
        }
    }

    private static final class ModuleVersionSelectionEditingSupport
    extends TypedEditingSupport<ModuleVersionSelection, String> {
        private final ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
        private ModuleVersionSelection currentElement;

        private ModuleVersionSelectionEditingSupport(final ColumnViewer viewer) {
            super(viewer);
            this.cellEditor.setActivationStyle(2);
            this.cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.cellEditor.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ModuleVersionSelection selection;
                    Object firstElement;
                    String version;
                    IStructuredSelection structuredSelection = event.getStructuredSelection();
                    if (structuredSelection != null && (version = (String)structuredSelection.getFirstElement()) != null && (firstElement = viewer.getStructuredSelection().getFirstElement()) instanceof ModuleVersionSelection && currentElement == (selection = (ModuleVersionSelection)firstElement)) {
                        selection.setCurrentVersion(version);
                    }
                }
            });
        }

        protected void setElementValue(ModuleVersionSelection element, String value) {
            if (value != null) {
                element.setCurrentVersion(value);
                this.getViewer().update((Object)element, null);
            }
        }

        protected String getValueFrom(ModuleVersionSelection element) {
            String currentVersion = element.getCurrentVersion();
            return currentVersion;
        }

        protected CellEditor getCellEditorFor(ModuleVersionSelection element) {
            this.currentElement = element;
            ModuleVersionSelection moduleVersionSelection = element;
            List<String> availableVersionsList = moduleVersionSelection.getAvailableVersions();
            String[] availableVersions = availableVersionsList.toArray(new String[availableVersionsList.size()]);
            this.cellEditor.setInput((Object)availableVersions);
            this.cellEditor.getViewer().setSelection((ISelection)new StructuredSelection((Object)moduleVersionSelection.getCurrentVersion()));
            return this.cellEditor;
        }

        protected boolean canEditElement(ModuleVersionSelection element) {
            return ModuleVersionSelectionEditingSupport.isVersionEditable(element);
        }

        public static boolean isVersionEditable(Object object) {
            return object instanceof ModuleVersionSelection && ((ModuleVersionSelection)object).getAvailableVersions().size() > 1;
        }
    }

    public class SearchComposite
    extends Composite {
        private SearchTextField searchTextField;
        private TableViewer resultsTable;
        private List<Organization> organizations;
        private Label label;
        private Link resultsLabelLink;
        private Link openPreferencePage;

        public SearchComposite(Composite parent, int style) {
            super(parent, style);
            this.organizations = Collections.emptyList();
            FormLayoutUtils.setFormLayout((Composite)this);
            this.create();
        }

        private void create() {
            this.createSearchText();
            this.createLabel();
            this.createPreferencePageLink();
            this.createTable();
            this.createMoreResultsLink();
        }

        private void createLabel() {
            this.label = WidgetUtils.label((Composite)this, (String)AddDependencyView.this.getSearchTitle());
            FormLayoutUtils.attach((Control)this.label).topFrom((Control)this.searchTextField, 5).left().right();
        }

        private void createTable() {
            this.getShell().setMinimumSize(INITIAL_MIN_SIZE);
            this.resultsTable = new TableViewer((Composite)this, 68352);
            this.resultsTable.getTable().setLinesVisible(true);
            this.resultsTable.getTable().setHeaderVisible(true);
            this.resultsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            SearchResultLabelProvider labelProvider = new SearchResultLabelProvider(() -> this.searchTextField.getText(), this.resultsTable.getTable().getFont()){

                protected String getText(Object element) {
                    if (element instanceof ExternalContributionMuleModule) {
                        ExternalContributionMuleModule ext = (ExternalContributionMuleModule)element;
                        return ext.getLabel();
                    }
                    if (element instanceof ExchangeAsset) {
                        ExchangeAsset asset = (ExchangeAsset)element;
                        return asset.getName();
                    }
                    return "";
                }
            };
            labelProvider.setOwnerDrawEnabled(true);
            WidgetUtils.createColumn((TableViewer)this.resultsTable, (String)AddDependencyView.COL_NAME, (CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
            WidgetUtils.createColumn((TableViewer)this.resultsTable, (String)AddDependencyView.COL_PUBLISHER, element -> {
                if (element instanceof ExternalContributionMuleModule) {
                    return AddDependencyView.MULESOFT;
                }
                if (element instanceof ExchangeAsset) {
                    ExchangeAsset asset = (ExchangeAsset)element;
                    return this.getOrganizationName(asset.getOrganizationId());
                }
                return "";
            });
            WidgetUtils.createColumn((TableViewer)this.resultsTable, (String)AddDependencyView.COL_TYPE, element -> {
                if (element instanceof ExchangeAsset) {
                    ExchangeAsset asset = (ExchangeAsset)element;
                    return ClassifierType.mapClassifier(asset.getClassifier());
                }
                return "";
            });
            WidgetUtils.createColumn((TableViewer)this.resultsTable, (String)AddDependencyView.COL_LATEST_VERSION, element -> {
                if (element instanceof ExchangeAsset) {
                    ExchangeAsset asset = (ExchangeAsset)element;
                    return asset.getVersion();
                }
                return "";
            });
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
            this.resultsTable.getTable().setLayout((Layout)layout);
            FormLayoutUtils.attach((Control)this.resultsTable.getTable()).topFrom((Control)this.label, 5).left().right().bottomFrom((Control)this.openPreferencePage);
        }

        private String getOrganizationName(String organizationId) {
            return RegionUrlResolver.getInstance().getPlatformRegion().getMasterOrgId().equals(organizationId) ? AddDependencyView.MULESOFT : this.organizations.stream().filter(org -> org.getId().equals(organizationId)).map(org -> org.getName()).findFirst().orElse("");
        }

        private void createMoreResultsLink() {
            this.resultsLabelLink = new Link((Composite)this, 0);
            this.resultsLabelLink.setText(AddDependencyView.MULTI_PAGE_RESULTS_LABEL);
            FormLayoutUtils.attach((Control)this.resultsLabelLink).left().right().topFrom((Control)this.resultsTable.getTable(), 5).bottomFrom((Control)this.openPreferencePage, 5);
        }

        private void createSearchText() {
            this.searchTextField = new SearchTextField((Composite)this, "Type a search term to look up in Exchange");
            this.searchTextField.addTraverseListener(event -> {
                boolean bl = event.doit = event.doit & event.detail != 4;
            });
            FormLayoutUtils.attach((Control)this.searchTextField).top().left().right();
        }

        private void createPreferencePageLink() {
            this.openPreferencePage = new Link((Composite)this, 0);
            this.openPreferencePage.setText("<A>Open Exchange Preference Page</A>");
            this.openPreferencePage.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> ExchangePreferences.openPreferencePage((Shell)this.getShell())));
            FormLayoutUtils.attach((Control)this.openPreferencePage).left().right().bottom();
        }

        public void setOrganizations(List<Organization> organizations) {
            this.organizations = organizations;
        }

        public void addSearchListener(ModifyListener listener) {
            this.searchTextField.addModifyListener((ModifyListener)new IdleModifyEventListener(listener, (Control)this.searchTextField));
        }

        public void addSelectionListener(ISelectionChangedListener listener) {
            this.resultsTable.addSelectionChangedListener(listener);
        }

        public void addShowMoreListener(Listener listener) {
            this.resultsLabelLink.addListener(14, listener);
        }

        public Link getResultsLabelLink() {
            return this.resultsLabelLink;
        }

        public SearchTextField getSearchTextField() {
            return this.searchTextField;
        }

        public TableViewer getResultsTable() {
            return this.resultsTable;
        }
    }
}

