/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.authentication.preferences.AuthenticationPreferencePage;
import org.mule.tooling.ui.authentication.widgets.WebLogin;

public class PlatformLoginComponent {
    private static Font boldFont;
    private static Font italicFont;
    private String logInPrompt;
    private String changeSettingsPrompt;
    private Optional<String> currentAccountMessage;
    private Optional<String> notLoggedMessage;
    private Composite thisComposite;
    private Label accountDetailsLabel;
    private Link accountDetailsLink;
    private Optional<AuthUser> currentUser;
    private List<Consumer<Optional<AuthUser>>> loginListeners;

    public PlatformLoginComponent(String logInPrompt, String changeSettingsPrompt, Optional<String> currentAccountMessage, Optional<String> notLoggedMessage) {
        this.logInPrompt = logInPrompt;
        this.changeSettingsPrompt = changeSettingsPrompt;
        this.currentAccountMessage = currentAccountMessage;
        this.notLoggedMessage = notLoggedMessage;
        this.currentUser = Optional.empty();
        this.loginListeners = new LinkedList<Consumer<Optional<AuthUser>>>();
    }

    private void setItalicFont(Link accountDetailsLink) {
        if (italicFont == null) {
            italicFont = FontDescriptor.createFrom((Font)accountDetailsLink.getFont()).setStyle(2).createFont((Device)accountDetailsLink.getDisplay());
        }
        accountDetailsLink.setFont(italicFont);
    }

    private void setBoldFont(Label label) {
        if (boldFont == null) {
            boldFont = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1).createFont((Device)label.getDisplay());
        }
        label.setFont(boldFont);
    }

    public Composite getComposite() {
        return this.thisComposite;
    }

    public void createControls(Composite parent) {
        this.thisComposite = new Composite(parent, 0);
        RowLayoutFactory.fillDefaults().type(256).applyTo(this.thisComposite);
        this.accountDetailsLabel = new Label(this.thisComposite, 0);
        this.accountDetailsLabel.setText(this.notLoggedMessage.orElse(""));
        this.setBoldFont(this.accountDetailsLabel);
        this.accountDetailsLink = new Link(this.thisComposite, 0);
        this.accountDetailsLink.setText("<a>" + this.logInPrompt + "</a>");
        this.setItalicFont(this.accountDetailsLink);
        this.accountDetailsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformLoginComponent.this.onDetailsLinkClicked();
            }
        });
        this.update();
    }

    private void onDetailsLinkClicked() {
        if (this.isLoggedIn() || !CoreUtils.getLoginManager().retrieveAuthUsers().isEmpty()) {
            AuthenticationPreferencePage.openPreferencePage((Shell)Display.getCurrent().getActiveShell());
        } else {
            WebLogin webLogin = new WebLogin();
            webLogin.setBlockOnOpen(true);
            webLogin.open();
        }
        this.update();
    }

    private boolean isLoggedIn() {
        return this.currentUser.isPresent();
    }

    private void update() {
        AuthUser newUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        if (this.currentUser.map(user -> !user.equals((Object)newUser)).orElse(true).booleanValue()) {
            if (newUser != null && CoreUtils.getLoginManager().isTokenValid(newUser).succeeded()) {
                this.currentUser = Optional.of(newUser);
                this.updateWithUser(newUser);
            } else {
                this.currentUser = Optional.empty();
                this.updateNotLoggedIn();
            }
            this.loginListeners.forEach(listener -> listener.accept(this.currentUser));
        }
        this.thisComposite.getParent().layout();
    }

    private void updateWithUser(AuthUser user) {
        this.accountDetailsLabel.setText(MessageFormat.format(this.currentAccountMessage.orElse(""), user.getUserId()));
        this.accountDetailsLink.setText("<a>" + this.changeSettingsPrompt + "</a>");
    }

    private void updateNotLoggedIn() {
        this.accountDetailsLabel.setText(this.notLoggedMessage.orElse(""));
        List users = CoreUtils.getLoginManager().retrieveAuthUsers();
        this.accountDetailsLink.setText("<a>" + (users.isEmpty() ? this.logInPrompt : this.changeSettingsPrompt) + "</a>");
    }

    public void onLoginChanged(Consumer<Optional<AuthUser>> loginListener) {
        this.loginListeners.add(loginListener);
    }
}

