/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleProjectAdapterFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.project.RuntimeConfigurationComponent;
import org.mule.tooling.ui.utils.RuntimeUpdateDialogUtils;
import org.mule.tooling.ui.utils.UiUtils;

public class MuleProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private RuntimeConfigurationComponent runtimeConfigurationComponent;
    private IMuleProject muleProject;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        if (!(element instanceof IProject) && !(element instanceof IJavaProject)) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " properties page should only be loaded when a mule project is selected");
        }
        this.muleProject = (IMuleProject)new MuleProjectAdapterFactory().getAdapter((Object)element, null);
    }

    protected Control createContents(Composite parent) {
        this.runtimeConfigurationComponent = new RuntimeConfigurationComponent(parent);
        Group runtimeGroup = UiUtils.createGroupWithTitle(parent, "Project Runtime Configuration", 1);
        try {
            this.runtimeConfigurationComponent.createControl((Composite)runtimeGroup);
            if (MuleProjectKind.APPLICATION.classifies(this.muleProject)) {
                this.runtimeConfigurationComponent.loadDomainsInput(this.muleProject);
            }
            this.runtimeConfigurationComponent.loadFromMuleProject(this.muleProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return parent;
    }

    protected void performApply() {
        super.performApply();
        this.runtimeConfigurationComponent.commit();
    }

    public boolean performOk() {
        try {
            if (RuntimeUpdateDialogUtils.showUpdateRuntimeDialog()) {
                CoreUtils.updateFieldInMuleArtifactJson((File)this.muleProject.getMuleArtifactFile().getLocation().toFile(), (String)"minMuleVersion", (Object)this.muleProject.getServerDefinition().getVersionWithPatchVersionZero());
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error trying to modify the mule-artifact.json file.", (Throwable)e);
        }
        return super.performOk();
    }
}

