/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.ExchangeMavenFacade;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.utils.ObjectHolder;

public abstract class MuleMavenProjectDependencyManager
implements IDependencyManager<MavenDependency> {
    protected MavenMuleProjectDecorator mavenMuleProjectDecorator;

    public MuleMavenProjectDependencyManager(MavenMuleProjectDecorator mavenProjectDecorator) {
        this.mavenMuleProjectDecorator = mavenProjectDecorator;
    }

    public MuleMavenProjectDependencyManager(IMuleProject project) {
        this.mavenMuleProjectDecorator = MavenMuleProjectDecorator.decorate((IMuleProject)project);
    }

    @Override
    public abstract void forceSnapshotUpdate(MavenDependency var1);

    @Override
    public abstract CompletableFuture<Boolean> checkNewSnapshot(MavenDependency var1);

    @Override
    public abstract List<MavenDependency> getDependencies();

    @Override
    public IDependencyManager.Result<MavenDependency> resolveDependency(MavenDependency dependency) {
        ObjectHolder result = new ObjectHolder();
        IMuleProject muleProject = this.mavenMuleProjectDecorator.getMuleProject();
        List<MavenDependency> depList = Arrays.asList(dependency);
        ArtifactResolvingRunnerFactory.syncInstance().runResolvingDependencies(muleProject, Arrays.asList(dependency), DependenciesCallback.builder().onSuccess(resolvedArtifacts -> resolvedArtifacts.keySet().stream().filter(dep -> this.isContainedIn((MavenDependency)dep, depList)).findFirst().ifPresent(successDep -> {
            Object object = result.set(new IDependencyManager.Result<MavenDependency>((MavenDependency)successDep));
        })).onError(errorsMap -> {
            Object object = result.set(new IDependencyManager.Result((Map<MavenDependency, List<Exception>>)errorsMap));
        }).build(), (IProgressMonitor)new NullProgressMonitor());
        return (IDependencyManager.Result)result.get();
    }

    @Override
    public IDependencyManager.Result<MavenDependency> removeDependencyFromProject(MavenDependency dependency) {
        IDependencyManager.Result<MavenDependency> resolvedDependency = this.resolveDependency(dependency);
        resolvedDependency.getResult().ifPresent(dependencyToRemove -> this.mavenMuleProjectDecorator.removeDependency(dependencyToRemove));
        return resolvedDependency;
    }

    @Override
    public IDependencyManager.Result<MavenDependency> removeDependenciesFromProject(Collection<IDependency> dependencies) {
        if (dependencies.isEmpty()) {
            return null;
        }
        List results = dependencies.stream().map(dependency -> this.removeDependencyFromProject(dependency.getDependency())).collect(Collectors.toList());
        for (IDependencyManager.Result result : results) {
            if (!result.isFailure()) continue;
            return result;
        }
        return (IDependencyManager.Result)results.get(results.size() - 1);
    }

    @Override
    public IDependencyManager.Result<MavenDependency> addDependencyToProject(MavenDependency dependency) {
        if (this.isAddExchangeRepositoriesToPomEnabled()) {
            this.addExchangeMavenRepositoryIfNecessary();
        }
        IDependencyManager.Result<MavenDependency> resolvedDependency = this.resolveDependency(dependency);
        resolvedDependency.getResult().ifPresent(dependencyToAdd -> this.mavenMuleProjectDecorator.addDependency(dependencyToAdd));
        return resolvedDependency;
    }

    private boolean isAddExchangeRepositoriesToPomEnabled() {
        return MuleUIPlugin.getDefault().getPreferenceStore().getBoolean("add_exchange_repositories_to pom");
    }

    private void addExchangeMavenRepositoryIfNecessary() {
        Optional<Repository> exchangeCurrentRepository = this.mavenMuleProjectDecorator.getRepositories().stream().filter(repository -> ExchangeMavenFacade.getCurrentId().equals(repository.getId())).findFirst();
        if (!exchangeCurrentRepository.isPresent()) {
            Optional<Repository> oldExchangeRepository = this.mavenMuleProjectDecorator.getRepositories().stream().filter(repository -> ExchangeMavenFacade.getOldRepositoryIds().contains(repository.getId())).findFirst();
            if (oldExchangeRepository.isPresent()) {
                this.mavenMuleProjectDecorator.addRepositoryBefore(ExchangeMavenFacade.getCurrentId(), ExchangeMavenFacade.getCurrentName(), PlatformUrls.getMavenFacadeUrl(), oldExchangeRepository.get());
            } else {
                this.mavenMuleProjectDecorator.addRepository(ExchangeMavenFacade.getCurrentId(), ExchangeMavenFacade.getCurrentName(), PlatformUrls.getMavenFacadeUrl());
            }
        }
    }

    @Override
    public IDependencyManager.Result<List<MavenDependency>> resolveDependencies(List<MavenDependency> dependencies) {
        ObjectHolder result = new ObjectHolder();
        IMuleProject muleProject = this.mavenMuleProjectDecorator.getMuleProject();
        ArtifactResolvingRunnerFactory.syncInstance().runResolvingDependencies(muleProject, dependencies, DependenciesCallback.builder().onSuccess(resolvedArtifacts -> {
            Object object = result.set(new IDependencyManager.Result(resolvedArtifacts.keySet().stream().filter(dep -> this.isContainedIn((MavenDependency)dep, dependencies)).collect(Collectors.toList())));
        }).onError(errorsMap -> {
            Object object = result.set(new IDependencyManager.Result((Map<MavenDependency, List<Exception>>)errorsMap));
        }).build(), (IProgressMonitor)new NullProgressMonitor());
        return (IDependencyManager.Result)result.get();
    }

    private boolean isContainedIn(MavenDependency dep, List<MavenDependency> dependencies) {
        return dependencies.stream().anyMatch(depToMatch -> MavenUtils.getGAV((MavenDependency)depToMatch).equals(MavenUtils.getGAV((MavenDependency)dep)));
    }

    @Override
    public void asyncResolveDependencies(List<MavenDependency> dependencies, Callback<List<MavenDependency>> callback) {
        if (this.isAddExchangeRepositoriesToPomEnabled()) {
            this.addExchangeMavenRepositoryIfNecessary();
        }
        IMuleProject muleProject = this.mavenMuleProjectDecorator.getMuleProject();
        ArtifactResolvingRunnerFactory.asyncInstance().runResolvingDependencies(muleProject, dependencies, DependenciesCallback.builder().onSuccess(resolvedArtifacts -> callback.onSuccess(resolvedArtifacts.keySet().stream().filter(dep -> this.isContainedIn((MavenDependency)dep, dependencies)).collect(Collectors.toList()))).onError(errorsMap -> callback.onError(errorsMap)).doFinally(() -> callback.doFinally()).build(), (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void asyncResolveDependency(MavenDependency dependency, Callback<MavenDependency> callback) {
        IMuleProject muleProject = this.mavenMuleProjectDecorator.getMuleProject();
        List<MavenDependency> depList = Arrays.asList(dependency);
        ArtifactResolvingRunnerFactory.asyncInstance().runResolvingDependencies(muleProject, depList, DependenciesCallback.builder().onSuccess(resolvedArtifacts -> callback.onSuccess((Object)resolvedArtifacts.keySet().stream().filter(dep -> this.isContainedIn((MavenDependency)dep, depList)).findFirst().get())).onError(errorsMap -> callback.onError(errorsMap)).doFinally(() -> callback.doFinally()).build(), (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean supportSnapshots() {
        return true;
    }
}

