/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.ui.editors.DependenciesTable;
import org.mule.tooling.ui.editors.DependencyInfo;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IFetchDependenciesVersionsListener;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public abstract class MuleDependenciesView
extends Composite
implements IFetchDependenciesVersionsListener {
    private Composite dialog;
    private DependenciesTable dependenciesTable;
    protected DependencyInfo dependencyInfo;
    protected DependencyController<?> dependencyController;

    public MuleDependenciesView(DependencyController<?> dependencyController, Composite parent) {
        super(parent, 0);
        this.dependencyController = dependencyController;
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        this.createView(this);
    }

    public Control createView(Composite parent) {
        this.createDialog(parent);
        this.createDependenciesTable();
        this.createDependencyInfo();
        FormLayoutUtils.attach((Control)this.dependenciesTable).top().left().right().bottom(50, 0);
        FormLayoutUtils.attach((Control)this.dependencyInfo).topFrom((Control)this.dependenciesTable, 5).left().right().bottom();
        return this.dialog;
    }

    public DependencyInfo.ProgressComposite getProgress() {
        return this.dependencyInfo.getProgress();
    }

    private void createDependencyInfo() {
        this.dependencyInfo = new DependencyInfo(this.getDependencyController(), this.dialog, 0);
        this.getDependencyController().addActionListener(this.dependencyInfo);
        this.getDependencyController().addSelectionListener(this.dependencyInfo);
        this.lateInitializeInput();
    }

    private void createDependenciesTable() {
        this.dependenciesTable = new DependenciesTable(this.getDependencyController(), this.dialog, 0);
        this.addColumns();
        this.initializeInput();
        this.contributeAddItems();
        this.dependenciesTable.createContent();
        this.getDependencyController().addActionListener(this.dependenciesTable);
        this.dependenciesTable.addFetchDependenciesListener(this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dependenciesTable.getDependenciesTableViewer());
    }

    private void createDialog(Composite parent) {
        this.dialog = FormLayoutUtils.composite((Composite)parent);
        FormLayoutUtils.attach((Control)this.dialog).top().left().right().bottom();
    }

    public void restoreDefaults() {
        this.dependencyController.restoreDefaults();
        this.dependenciesTable.restoreDefaults();
    }

    public void performOk() {
        this.getDependencyController().applyChanges();
        if (this.dependenciesTable != null) {
            this.dependenciesTable.apply();
        }
    }

    public DependenciesTable getDependenciesTable() {
        return this.dependenciesTable;
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyInfo;
    }

    public void setApplyButton(Button applyButton) {
        this.getDependencyController().setApplyButton(applyButton);
    }

    protected void repackDialog() {
        this.getShell().pack();
    }

    protected void contributeAddItems() {
        this.getDependenciesTable().contributeAddItem("from Exchange", () -> this.dependencyController.searchInExchange());
        this.getDependenciesTable().contributeAddItem("from Maven", () -> this.dependencyController.addMavenDependency());
    }

    protected abstract void addColumns();

    protected void initializeInput() {
        this.getDependenciesTable().setInput(this.dependencyController.getDependencies());
    }

    private void lateInitializeInput() {
        this.populateVersions(this.getDependenciesTable().getInput());
    }

    @Override
    public void fetchAllDependenciesVersions() {
        this.populateVersions(this.getDependenciesTable().getModifiedInput());
    }

    public void refreshCheckForUpdatesButton() {
        this.dependenciesTable.refreshCheckForUpdatesButton();
    }

    private void populateVersions(List<IDependency> dependenciesList) {
        if (!dependenciesList.isEmpty()) {
            this.dependenciesTable.disableCheckForUpdatesButton();
            this.dependencyController.fetchVersions(dependenciesList, this.getProgress());
        }
    }

    public DependencyController<?> getDependencyController() {
        return this.dependencyController;
    }
}

