/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.Collections;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.properties.DependencyClassifierLabelProvider;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.DependencyNameLabelProvider;
import org.mule.tooling.ui.properties.DependencyVersionLabelProvider;
import org.mule.tooling.ui.properties.MuleDependenciesView;

public class MuleAPIDependenciesView
extends MuleDependenciesView {
    public static final String ENABLE_API_DEPENDENCIES_ID = "org.mule.tooling.ui.properties.enable.api.dependencies";
    private static final String FROM_DEPENDENCY_NOT_ENABLED = "Your current Private Cloud Edition does not allow API dependencies";
    private static final String NAME_COL = "Name";
    private static final String TYPE_COL = "Asset type";
    private static final String VERSION_COL = "Version";

    public MuleAPIDependenciesView(DependencyController<?> dependencyController, Composite parent) {
        super(dependencyController, parent);
    }

    @Override
    protected void addColumns() {
        this.getDependenciesTable().addColumn(NAME_COL, 200, dependency -> dependency.getName(), (dependency, value) -> {}, dependency -> Collections.emptySet(), (CellLabelProvider)new DependencyNameLabelProvider());
        this.getDependenciesTable().addColumn(TYPE_COL, 50, dependency -> dependency.getClassifier(), (dependency, value) -> {}, dependency -> Collections.emptySet(), (CellLabelProvider)new DependencyClassifierLabelProvider());
        this.getDependenciesTable().addColumn(VERSION_COL, 80, dependency -> dependency.getVersion(), (dependency, value) -> dependency.setVersion(value), dependency -> dependency.getAvailableVersions(), (CellLabelProvider)new DependencyVersionLabelProvider());
    }

    @Override
    public Control createView(Composite parent) {
        boolean apiDependenciesAreEnabled = LoginManager.getPreferences().getBoolean(ENABLE_API_DEPENDENCIES_ID, false);
        Control resultingControl = null;
        if (apiDependenciesAreEnabled) {
            resultingControl = super.createView(parent);
        } else {
            Composite linkComposite = new Composite(parent, 0);
            Color transparentColor = parent.getDisplay().getSystemColor(37);
            CLabel label = new CLabel(linkComposite, 0);
            label.setImage(MuleImages.IMG_INFO);
            label.setText(FROM_DEPENDENCY_NOT_ENABLED);
            parent.setBackground(transparentColor);
            label.setBackground(transparentColor);
            linkComposite.setBackground(transparentColor);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).indent(0, 2).applyTo((Control)label);
            GridLayoutFactory.fillDefaults().numColumns(3).spacing(2, -1).applyTo(linkComposite);
            resultingControl = linkComposite;
        }
        return resultingControl;
    }

    @Override
    public void restoreDefaults() {
        boolean apiDependenciesAreEnabled = LoginManager.getPreferences().getBoolean(ENABLE_API_DEPENDENCIES_ID, false);
        if (apiDependenciesAreEnabled) {
            super.restoreDefaults();
        }
    }
}

