/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.utils.ObjectHolder;

public class ModuleDependencyManager
implements IDependencyManager<ExternalContributionMuleModule> {
    private IMuleProject muleProject;

    public ModuleDependencyManager(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    @Override
    public IDependencyManager.Result<ExternalContributionMuleModule> resolveDependency(MavenDependency dependency) {
        ObjectHolder result = new ObjectHolder();
        ArtifactResolvingRunnerFactory.syncInstance().runResolvingExtension(this.muleProject, dependency, SingleExtensionCallback.builder().onSuccess(externalModule -> result.set(new IDependencyManager.Result<ExternalContributionMuleModule>((ExternalContributionMuleModule)externalModule))).onError(depToExceptions -> result.set(new IDependencyManager.Result((Map<MavenDependency, List<Exception>>)depToExceptions))).build(), (IProgressMonitor)new NullProgressMonitor());
        return (IDependencyManager.Result)result.get();
    }

    @Override
    public IDependencyManager.Result<ExternalContributionMuleModule> removeDependencyFromProject(MavenDependency dependency) {
        IDependencyManager.Result<ExternalContributionMuleModule> result;
        try {
            IDependencyManager.Result<ExternalContributionMuleModule> resolveDependency = this.resolveDependency(dependency);
            if (resolveDependency.isFailure()) {
                return resolveDependency;
            }
            ExternalContributionMuleModule removedDependency = resolveDependency.getResult().get();
            this.muleProject.removeMuleExtension(removedDependency);
            result = new IDependencyManager.Result<ExternalContributionMuleModule>(removedDependency);
        }
        catch (CoreException e) {
            result = new IDependencyManager.Result<ExternalContributionMuleModule>(Collections.singletonMap(dependency, Arrays.asList(new Exception[]{e})));
        }
        return result;
    }

    @Override
    public IDependencyManager.Result<ExternalContributionMuleModule> removeDependenciesFromProject(Collection<IDependency> dependencies) {
        if (dependencies.isEmpty()) {
            return null;
        }
        List results = dependencies.stream().map(dependency -> this.removeDependencyFromProject(dependency.getDependency())).collect(Collectors.toList());
        for (IDependencyManager.Result result : results) {
            if (!result.isFailure()) continue;
            return result;
        }
        return (IDependencyManager.Result)results.get(results.size() - 1);
    }

    @Override
    public IDependencyManager.Result<ExternalContributionMuleModule> addDependencyToProject(MavenDependency dependency) {
        IDependencyManager.Result<Object> resolveDependency = this.resolveDependency(dependency);
        if (resolveDependency.isFailure()) {
            return resolveDependency;
        }
        try {
            ExternalContributionMuleModule module = resolveDependency.getResult().get();
            if (MavenDependency.Scope.TEST.equals((Object)dependency.getScope())) {
                this.muleProject.addMuleTestExtension(module);
            } else {
                this.muleProject.addMuleExtension(module);
            }
        }
        catch (CoreException e) {
            resolveDependency = new IDependencyManager.Result(Collections.singletonMap(dependency, Arrays.asList(new Exception[]{e})));
        }
        return resolveDependency;
    }

    @Override
    public List<ExternalContributionMuleModule> getDependencies() {
        return this.muleProject.getModuleManager(EditingScope.TEST).getExternalModules();
    }

    @Override
    public IDependencyManager.Result<List<ExternalContributionMuleModule>> resolveDependencies(List<MavenDependency> dependency) {
        ObjectHolder result = new ObjectHolder();
        ArtifactResolvingRunnerFactory.syncInstance().runResolvingExtensions(this.muleProject, dependency, ExtensionsCallback.builder().onSuccess(externalModules -> result.set(new IDependencyManager.Result<List>((List)externalModules))).onError(depToExceptions -> result.set(new IDependencyManager.Result((Map<MavenDependency, List<Exception>>)depToExceptions))).build(), (IProgressMonitor)new NullProgressMonitor());
        return (IDependencyManager.Result)result.get();
    }

    @Override
    public void asyncResolveDependencies(List<MavenDependency> dependency, Callback<List<ExternalContributionMuleModule>> callback) {
        ArtifactResolvingRunnerFactory.asyncInstance().runResolvingExtensions(this.muleProject, dependency, callback, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void asyncResolveDependency(MavenDependency dependency, Callback<ExternalContributionMuleModule> callback) {
        ArtifactResolvingRunnerFactory.asyncInstance().runResolvingExtension(this.muleProject, dependency, callback, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void forceSnapshotUpdate(MavenDependency dependency) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<Boolean> checkNewSnapshot(MavenDependency dependency) {
        throw new NotImplementedException();
    }
}

