/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.ui.properties.IDependency;

public interface IDependencyManager<T> {
    public Result<List<T>> resolveDependencies(List<MavenDependency> var1);

    public Result<T> resolveDependency(MavenDependency var1);

    public void asyncResolveDependencies(List<MavenDependency> var1, Callback<List<T>> var2);

    public void asyncResolveDependency(MavenDependency var1, Callback<T> var2);

    public Result<T> removeDependencyFromProject(MavenDependency var1);

    public Result<T> removeDependenciesFromProject(Collection<IDependency> var1);

    public Result<T> addDependencyToProject(MavenDependency var1);

    public CompletableFuture<Boolean> checkNewSnapshot(MavenDependency var1);

    public void forceSnapshotUpdate(MavenDependency var1);

    public List<T> getDependencies();

    default public boolean supportSnapshots() {
        return false;
    }

    public static final class Result<T> {
        private T result;
        private Map<MavenDependency, List<Exception>> exception;
        private boolean isFailure;

        public Result(T result) {
            this.result = result;
            this.isFailure = false;
        }

        public Result(Map<MavenDependency, List<Exception>> e) {
            this.exception = e;
            this.isFailure = true;
        }

        public Optional<T> getResult() {
            return Optional.ofNullable(this.result);
        }

        public Optional<Map<MavenDependency, List<Exception>>> getFailure() {
            return Optional.ofNullable(this.exception);
        }

        public boolean isFailure() {
            return this.isFailure;
        }
    }
}

