/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.editors.DependenciesTable;
import org.mule.tooling.ui.properties.DependencyVersions;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class EditDependencyDialog
extends Dialog {
    private static final String UPDATE_AVAILABLE = "Update available";
    private static final String OK_TEXT = "OK";
    private static final String CANCEL_TEXT = "Cancel";
    private static final String VERSION = "version";
    private IDependency dependency;
    private Composite editComposite;
    private Map<DependenciesTable.ModifyAction, String> toApply = new HashMap<DependenciesTable.ModifyAction, String>();
    private Shell shell;
    private Runnable onFinish;
    private List<DependenciesTable.DependencyColumn> columns;

    public EditDependencyDialog(DependenciesTable table, IDependency dependency) {
        super(table.getParent().getShell(), 0x10000000);
        this.columns = table.getColumns();
        this.dependency = dependency;
    }

    private void configureInitialSize(Shell shell) {
        shell.setMinimumSize(new Point(200, 230));
    }

    public void open(Runnable onFinish) {
        this.onFinish = onFinish;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0x10000000);
        ThemeUtils.setCssId((Object)this.shell, (String)"editDependencyDialog");
        this.shell.setLayout((Layout)FormLayoutUtils.formLayout((int)15, (int)15));
        this.configureInitialSize(this.shell);
        this.editComposite = new Composite((Composite)this.shell, 0);
        this.editComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)10, (int)0));
        FormLayoutUtils.attach((Control)this.editComposite).top().left().right().bottom();
        DependenciesTable.DependencyColumn c = this.getColumn("Name");
        Label nameLabel = this.createLabel(c.getDisplay().apply(this.dependency), this.editComposite);
        FormLayoutUtils.attach((Control)nameLabel).top().left().right();
        final FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)nameLabel.getFont()).setStyle(1);
        final Font font = boldDescriptor.createFont((Device)nameLabel.getDisplay());
        nameLabel.setFont(font);
        nameLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                boldDescriptor.destroyFont(font);
            }
        });
        c = this.getColumn("Version");
        Control versions = this.createField(c.getName(), c.getDisplay().apply(this.dependency), c.getValues().apply(this.dependency), Optional.of(nameLabel), c.getUpdate());
        this.createButtons(versions);
        this.shell.pack();
        this.shell.open();
    }

    private DependenciesTable.DependencyColumn getColumn(String string) {
        return this.columns.stream().filter(c -> c.getName().equals(string)).findFirst().get();
    }

    private void createButtons(Control previusComposite) {
        Control okButton = this.createOK(previusComposite);
        this.createCancel(okButton);
    }

    private void createCancel(Control okButton) {
        Button cancel = new Button(this.editComposite, 8);
        cancel.setText(CANCEL_TEXT);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDependencyDialog.this.shell.close();
            }
        });
        FormLayoutUtils.attach((Control)cancel).rightFrom(okButton, 5).alignBottom(okButton);
    }

    private Control createOK(Control previusComposite) {
        Button ok = new Button(this.editComposite, 8);
        ok.setText(OK_TEXT);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDependencyDialog.this.toApply.forEach((update, value) -> update.apply(EditDependencyDialog.this.dependency, (String)value));
                EditDependencyDialog.this.onFinish.run();
                EditDependencyDialog.this.shell.close();
            }
        });
        FormLayoutUtils.attach((Control)ok).right(5).bottom();
        return ok;
    }

    private Control createField(String labelString, String value, Set<String> set, Optional<Control> previusComposite, DependenciesTable.ModifyAction modifyAction) {
        Composite fieldComposite = this.createFieldComposite(previusComposite);
        Label label = this.createLabel(labelString, fieldComposite);
        FormLayoutUtils.attach((Control)label).top().left().preferredWidth(125);
        this.createFieldEditor(value, set, modifyAction, fieldComposite, label);
        return fieldComposite;
    }

    private void createFieldEditor(String value, Set<String> values, DependenciesTable.ModifyAction setter, Composite fieldComposite, Label label) {
        if (values.size() > 1) {
            ComboViewer combo = new ComboViewer(fieldComposite, 12);
            ArrayList itemsArray = Lists.newArrayList(values);
            if (label.getText().equalsIgnoreCase(VERSION)) {
                itemsArray.sort(DependencyUtils.getVersionComparator());
            }
            DependencyVersions versions = new DependencyVersions(values, value);
            DependencyVersionChoice[] items = (DependencyVersionChoice[])itemsArray.stream().map(v -> new DependencyVersionChoice((String)v, versions)).toArray(DependencyVersionChoice[]::new);
            combo.setContentProvider((IContentProvider)new ArrayContentProvider());
            combo.setInput((Object)items);
            combo.setSelection((ISelection)new StructuredSelection((Object)new DependencyVersionChoice(value, versions)));
            combo.addSelectionChangedListener(e -> {
                DependencyVersionChoice selectedDependency = (DependencyVersionChoice)combo.getStructuredSelection().getFirstElement();
                this.toApply.put(setter, selectedDependency.getVersion());
            });
            FormLayoutUtils.attach((Control)combo.getControl()).top().leftFrom((Control)label, 2).right();
            if (!value.equals(versions.getLatest())) {
                Label updateAvailable = new Label(fieldComposite, 0);
                updateAvailable.setForeground(this.getParent().getDisplay().getSystemColor(15));
                updateAvailable.setText(UPDATE_AVAILABLE);
                FormLayoutUtils.attach((Control)updateAvailable).topFrom((Control)label, 1).left();
            }
        } else {
            Label text = new Label(fieldComposite, 0);
            text.setText(value);
            FormLayoutUtils.attach((Control)text).top().leftFrom((Control)label, 2).right().preferredWidth(100);
        }
    }

    private Label createLabel(String labelString, Composite fieldComposite) {
        Label label = new Label(fieldComposite, 0);
        label.setText(labelString);
        return label;
    }

    private Composite createFieldComposite(Optional<Control> previusComposite) {
        Composite fieldComposite = new Composite(this.editComposite, 0);
        fieldComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)0, (int)10));
        FormLayoutUtils.FormDataHelper attach = FormLayoutUtils.attach((Control)fieldComposite).left().right();
        if (previusComposite.isPresent()) {
            attach.topFrom(previusComposite.get(), 5);
        } else {
            attach.top();
        }
        return fieldComposite;
    }

    static final class DependencyVersionChoice {
        private static final String LATEST_PATCH = " (latest patch)";
        private static final String LATEST_MINOR_VERSION = " (latest minor version)";
        private static final String LATEST_VERSION = " (latest version)";
        private static final String CURRENT = " (current)";
        private final String version;
        private final String display;

        public DependencyVersionChoice(String thisVersion, DependencyVersions availableVersions) {
            this.version = thisVersion;
            this.display = this.getDisplay(availableVersions);
        }

        public String getDisplay(DependencyVersions availableVersions) {
            String description = "";
            if (availableVersions.getCurrent().equals(this.version)) {
                description = CURRENT;
            } else if (availableVersions.getLatest().equals(this.version)) {
                description = LATEST_VERSION;
            } else if (availableVersions.getLatestMinor().equals(this.version)) {
                description = LATEST_MINOR_VERSION;
            } else if (availableVersions.getLatestPatch().equals(this.version)) {
                description = LATEST_PATCH;
            }
            return this.getVersion() + description;
        }

        public String getDisplay() {
            return this.display;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.getDisplay();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyVersionChoice other = (DependencyVersionChoice)obj;
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

