/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.tooling.ui.m2.dependency.MuleVersionComparator;

public final class DependencyVersions {
    private static final MuleVersion ZERO_VERSION = new MuleVersion("0.0.0");
    private final List<MuleVersion> versions;
    private MuleVersion current;

    public DependencyVersions(Set<String> versions, String current) {
        this.versions = versions.stream().map(v -> new MuleVersion(v)).collect(Collectors.toList());
        this.current = new MuleVersion(current);
    }

    public String getCurrent() {
        return this.current.toString();
    }

    public String getLatest() {
        return this.versions.stream().max(MuleVersionComparator.INSTANCE).orElse(ZERO_VERSION).toString();
    }

    public String getLatestMinor() {
        return this.versions.stream().filter(v -> v.getMajor() == this.current.getMajor()).max(MuleVersionComparator.INSTANCE).orElse(ZERO_VERSION).toString();
    }

    public String getLatestPatch() {
        return this.versions.stream().filter(v -> v.getMajor() == this.current.getMajor()).filter(v -> v.getMinor() == this.current.getMinor()).filter(v -> StringUtils.isBlank((String)v.getSuffix())).max(MuleVersionComparator.INSTANCE).orElse(ZERO_VERSION).toString();
    }
}

