/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.Optional;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;

public class DependencyVersionLabelProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof IDependency && DependencyVersionLabelProvider.getNewerVersion((IDependency)element).isPresent()) {
            return MuleImages.IMG_BLUE_DOT;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IDependency) {
            return ((IDependency)element).getVersion();
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        Optional<String> newerVersion = DependencyVersionLabelProvider.getNewerVersion((IDependency)element);
        if (newerVersion.isPresent()) {
            return "There is a newer version: " + newerVersion.get();
        }
        return super.getToolTipText(element);
    }

    private static Optional<String> getNewerVersion(IDependency dependency) {
        String latest = DependencyUtils.getLatestVersion(dependency);
        if (!latest.equals(dependency.getVersion())) {
            return Optional.of(latest);
        }
        return Optional.empty();
    }
}

