/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.mule.tooling.ui.core.Stylers;
import org.mule.tooling.ui.properties.IDependency;

public class DependencyNameLabelProvider
extends StyledCellLabelProvider {
    private static final int MAX_ORG_LENGTH = 20;

    private String getOrg(IDependency dependency) {
        String organizationId = dependency.getOrganizationId();
        return "(" + (String)(organizationId.length() > 20 ? organizationId.substring(0, 8) + ".." + organizationId.substring(organizationId.length() - 10 + 2) : organizationId) + ")";
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof IDependency) {
            StyledString styledString = new StyledString();
            IDependency dependency = (IDependency)element;
            String name = dependency.getName();
            styledString.append(name + " ");
            String organization = this.getOrg(dependency);
            styledString.append(organization, Stylers.GRAY_STYLER);
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setText(styledString.getString());
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof IDependency) {
            return ((IDependency)element).getOrganizationId();
        }
        return super.getToolTipText(element);
    }
}

