/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.DependencyToAssetCache;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.ui.dependencies.SnapshotUpdateDialog;
import org.mule.tooling.ui.editors.DependencyInfo;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyActionListener;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.IDependencySelectedListener;
import org.mule.tooling.ui.properties.SnapshotState;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.properties.dependencies.IDependenciesFetcher;

public abstract class DependencyController<T extends IDependencyManager<?>> {
    private List<IDependencySelectedListener> selectionListeners = Lists.newArrayList();
    protected List<IDependencyActionListener> actionListeners = Lists.newArrayList();
    private List<Runnable> actions = Lists.newArrayList();
    private Map<IDependency, String> toUpdate = Maps.newHashMap();
    private Set<IDependency> toForceUpdate = Sets.newHashSet();
    private Set<IDependency> toAdd = Sets.newHashSet();
    private Set<IDependency> toRemove = Sets.newHashSet();
    private Map<IDependency, SnapshotState> snapshotStates = Maps.newHashMap();
    private Optional<Button> applyButton = Optional.empty();
    protected T dependencyManager;

    public DependencyController(T dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    public boolean supportSnapshots() {
        return this.dependencyManager.supportSnapshots();
    }

    public void addActionListener(IDependencyActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addSelectionListener(IDependencySelectedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void dependencySelected(Optional<IDependency> asset) {
        this.selectionListeners.forEach(listener -> listener.dependencySelected(asset));
    }

    public void dependenciesUpdated() {
        this.actionListeners.forEach(listener -> listener.dependenciesUpdated());
        this.refreshButton();
    }

    public void dependencyAdded(IDependency dependency) {
        this.toAdd.add(dependency);
        this.toRemove.remove(dependency);
        this.actionListeners.forEach(listener -> listener.dependencyAdded(dependency));
        this.refreshButton();
    }

    public void dependenciesAdded(List<IDependency> dependencies) {
        this.toAdd.addAll(dependencies);
        this.toRemove.removeAll(dependencies);
        this.actionListeners.forEach(listener -> listener.dependenciesAdded(dependencies));
        this.refreshButton();
    }

    public void dependencyRemoved(IDependency dependency) {
        if (!this.toAdd.remove(dependency)) {
            this.toRemove.add(dependency);
        }
        this.actionListeners.forEach(listener -> listener.dependencyRemoved(dependency));
        this.refreshButton();
    }

    public void versionChanged(IDependency dependency, String newVersion) {
        this.actionListeners.forEach(listener -> listener.dependencyUpdated(dependency));
        if (this.toAdd.contains(dependency)) {
            return;
        }
        if (newVersion.equals(dependency.getOriginalVersion())) {
            this.toUpdate.remove(dependency);
        } else {
            dependency.setVersion(newVersion);
            this.toUpdate.put(dependency, newVersion);
        }
        this.refreshButton();
    }

    public void snapshotChangeState(IDependency dependency) {
        SnapshotState state = this.getState(dependency);
        switch (state) {
            case UNCHECKED: {
                CompletableFuture<Boolean> checkSnapshot = this.dependencyManager.checkNewSnapshot(dependency.getDependency());
                Boolean newSnapshot = checkSnapshot.join();
                if (newSnapshot.booleanValue()) {
                    state = SnapshotState.NEW_UPDATE;
                    break;
                }
                state = SnapshotState.UPDATED;
                AnalyticsRecordsFactory.single((String)Events.NO_SNAPSHOT_UPDATE_AVAILABLE).track();
                break;
            }
            case NEW_UPDATE: {
                state = SnapshotState.FORCE_UPDATE;
                Optional exchangeAsset = DependencyToAssetCache.instance().getAssetFromExchange(dependency.getDependency(), new GraphServiceClient.AssetType[0]).getExchangeAsset();
                SnapshotUpdateDialog.openUpdateSnapshotWarningDialog(null, exchangeAsset);
                break;
            }
            case FORCE_UPDATE: {
                state = SnapshotState.UNCHECKED;
                break;
            }
        }
        if (state.equals((Object)SnapshotState.FORCE_UPDATE)) {
            this.toForceUpdate.add(dependency);
        } else {
            this.toForceUpdate.remove(dependency);
        }
        this.snapshotStates.put(dependency, state);
        this.actionListeners.forEach(listener -> listener.snapshotStateChanged(dependency, this.getState(dependency)));
        this.refreshButton();
    }

    public SnapshotState getState(IDependency snapshot) {
        return this.snapshotStates.computeIfAbsent(snapshot, dep -> SnapshotState.UNCHECKED);
    }

    public void applyChanges() {
        this.calculateActions();
        this.actions.forEach(action -> action.run());
        this.clear();
    }

    public void clear() {
        this.actions.clear();
        this.toAdd.clear();
        this.toRemove.clear();
        this.toUpdate.clear();
        this.toForceUpdate.clear();
        Set<IDependency> snapshots = this.snapshotStates.keySet();
        snapshots.forEach(snapshot -> {
            SnapshotState snapshotState = this.snapshotStates.put((IDependency)snapshot, SnapshotState.UNCHECKED);
        });
        this.refreshButton();
    }

    private void calculateActions() {
        this.addActions();
        this.removeActions();
        this.updateActions();
        this.forceUpdateActions();
    }

    private void addActions() {
        this.toAdd.forEach(dependency -> {
            boolean bl = this.actions.add(() -> this.dependencyManager.addDependencyToProject(dependency.getDependency()));
        });
    }

    private void removeActions() {
        this.toRemove.forEach(dependency -> {
            boolean bl = this.actions.add(() -> AnalyticsRecordsFactory.single((String)Events.DEPENDENCY_REMOVED).withDependencyProperty(Arrays.asList(dependency.getDependency())).track());
        });
        this.actions.add(() -> {
            IDependencyManager.Result result = this.dependencyManager.removeDependenciesFromProject(this.toRemove);
        });
    }

    private void updateActions() {
        this.toUpdate.forEach((dependency, version) -> {
            boolean bl = this.actions.add(() -> {
                dependency.setVersion(dependency.getOriginalVersion());
                this.dependencyManager.removeDependencyFromProject(dependency.getDependency());
                dependency.setVersion((String)version);
                dependency.setOriginalVersion((String)version);
                this.dependencyManager.addDependencyToProject(dependency.getDependency());
            });
        });
    }

    private void forceUpdateActions() {
        this.toForceUpdate.forEach(dependency -> {
            boolean bl = this.actions.add(() -> this.dependencyManager.forceSnapshotUpdate(dependency.getDependency()));
        });
    }

    public Set<IDependency> getDependenciesChanges() {
        return Stream.concat(Stream.concat(this.toAdd.stream(), this.toUpdate.keySet().stream()), this.toForceUpdate.stream()).collect(Collectors.toSet());
    }

    public void cancel() {
        this.actions.clear();
    }

    public void updateAll(List<IDependency> dependencies) {
        dependencies.forEach(dep -> {
            String latestVersion;
            String version = dep.getVersion();
            if (!version.equals(latestVersion = dep.getAvailableVersions().stream().map(v -> new MuleVersion(v)).max((v1, v2) -> v1.newerThan(v2) ? 1 : -1).get().toString())) {
                dep.setVersion(latestVersion);
                this.toUpdate.put((IDependency)dep, latestVersion);
            }
        });
        this.dependenciesUpdated();
    }

    public void setApplyButton(Button applyButton) {
        this.applyButton = Optional.of(applyButton);
        this.refreshButton();
    }

    public void refreshButton() {
        boolean atLeastOneAction = !this.toAdd.isEmpty() || !this.toUpdate.isEmpty() || !this.toRemove.isEmpty() || !this.toForceUpdate.isEmpty();
        this.applyButton.ifPresent(button -> {
            if (!button.isDisposed()) {
                button.setEnabled(atLeastOneAction);
            }
        });
    }

    public void addMavenDependency() {
    }

    public abstract List<IDependency> getDependencies();

    public abstract void searchInExchange();

    public void restoreDefaults() {
        this.toUpdate.forEach((dependency, newVersion) -> dependency.setVersion(dependency.getOriginalVersion()));
        this.clear();
    }

    public void fetchVersions(List<IDependency> list, DependencyInfo.ProgressComposite progress) {
        this.getVersionsFetcher(list, progress).fetchDependencies();
    }

    protected IDependenciesFetcher getVersionsFetcher(List<IDependency> list, DependencyInfo.ProgressComposite progress) {
        return new DependencyUtils.FetchUpdatesThread(Display.getCurrent(), progress.getProgressBar(), progress.getLabel(), list, this::consumeVersionsFetched, this.updateDependencies(progress), this.getAssetTypes());
    }

    protected GraphServiceClient.AssetType[] getAssetTypes() {
        return new GraphServiceClient.AssetType[]{GraphServiceClient.AssetType.EXTENSION, GraphServiceClient.AssetType.REST_API};
    }

    protected Runnable updateDependencies(DependencyInfo.ProgressComposite progress) {
        return () -> {
            progress.dispose();
            this.dependenciesUpdated();
        };
    }

    protected void consumeVersionsFetched(ExchangeAsset asset, IDependency dependency) {
        dependency.addAvailableVersion(asset.getVersion(), asset.getDescription());
    }
}

