/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.List;
import java.util.function.Function;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.dependencies.SearchHandler;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.properties.internal.AssetSelectionAdapter;

public abstract class DefaultWizardDependencyMode<T>
implements WizardDependencyMode<T> {
    private IDependencyManager<T> dependencyManager;
    private List<GraphServiceClient.AssetType> assetTypes;
    private SearchHandler searchHandler;
    private Function<ExchangeAsset, AssetSelectionAdapter> selectionAdapterFactory;

    public DefaultWizardDependencyMode(IDependencyManager<T> dependencyManager, List<GraphServiceClient.AssetType> assetTypes, SearchHandler searchHandler, Function<ExchangeAsset, AssetSelectionAdapter> selectionAdapterFactory) {
        this.assetTypes = assetTypes;
        this.dependencyManager = dependencyManager;
        this.searchHandler = searchHandler;
        this.selectionAdapterFactory = selectionAdapterFactory;
    }

    @Override
    public AssetSelectionAdapter adapt(ExchangeAsset asset) {
        return this.selectionAdapterFactory.apply(asset);
    }

    @Override
    public List<GraphServiceClient.AssetType> getAssetType() {
        return this.assetTypes;
    }

    @Override
    public SearchHandler getSearchHandler() {
        return this.searchHandler;
    }

    @Override
    public IDependencyManager<T> getDependencyManager() {
        return this.dependencyManager;
    }
}

