/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.tooling.core.m2.SnapshotUpdater;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.DependencyToAssetCache;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.ui.properties.MuleMavenProjectDependencyManager;

public class DataWeaveDependencyManager
extends MuleMavenProjectDependencyManager {
    public DataWeaveDependencyManager(MavenMuleProjectDecorator mavenProjectDecorator) {
        super(mavenProjectDecorator);
    }

    public DataWeaveDependencyManager(IMuleProject project) {
        this(MavenMuleProjectDecorator.decorate((IMuleProject)project));
    }

    @Override
    public List<MavenDependency> getDependencies() {
        return this.mavenMuleProjectDecorator.getMuleProject().getMuleProjectModel().getDataWeaveDependencies();
    }

    @Override
    public boolean supportSnapshots() {
        return true;
    }

    @Override
    public void forceSnapshotUpdate(MavenDependency dependency) {
        DependencyToAssetCache.instance().getAssetFrom(dependency).getNow(DependencyToAssetCache.GraphServiceCallResult.responseOkWithoutAsset()).getExchangeAsset();
    }

    @Override
    public CompletableFuture<Boolean> checkNewSnapshot(MavenDependency dependency) {
        Optional exchangeAsset = DependencyToAssetCache.instance().getAssetFromExchange(dependency, new GraphServiceClient.AssetType[0]).getExchangeAsset();
        if (exchangeAsset.isPresent()) {
            IMuleProject muleProject = this.mavenMuleProjectDecorator.getMuleProject();
            return SnapshotUpdater.resolveSnapshot((IMuleProject)muleProject, (ExchangeAsset)((ExchangeAsset)exchangeAsset.get())).thenCompose(snapshotResult -> CompletableFuture.completedFuture(snapshotResult.hasDiff()));
        }
        return CompletableFuture.completedFuture(false);
    }
}

