/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.properties;

public enum ClassifierType {
    RAML("raml", "REST API"),
    OAS("oas", "REST API"),
    EVENTED("evented-api", "AsyncAPI"),
    OTHER("other", "Other");

    private final String value;
    private final String mapping;

    private ClassifierType(String value, String mapping) {
        this.value = value;
        this.mapping = mapping;
    }

    public String getValue() {
        return this.value;
    }

    public String getMapping() {
        return this.mapping;
    }

    public static String mapClassifier(String classifier) {
        ClassifierType[] classifierTypeArray = ClassifierType.values();
        int n = classifierTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassifierType type = classifierTypeArray[n2];
            if (type.value.equalsIgnoreCase(classifier)) {
                return type.mapping;
            }
            ++n2;
        }
        return ClassifierType.OTHER.mapping;
    }
}

