/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project.extension;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class CreateGitignoreWizardPagePartExtension
implements WizardPagePartExtension {
    private static final String GITIGNORE_FILENAME = ".gitignore";
    private static final String GITIGNORE_MAVEN_TEMPLATE = "gitignore-maven-template";
    @WizardContext
    private IMuleProject muleProject;

    @Override
    public Control createControl(Composite parent) {
        return parent;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
        InputStream gitignoreResourceStream = null;
        monitor.beginTask("Creating .gitignore file for Studio project", 100);
        try {
            try {
                if (MuleUIPlugin.getDefault().getPreferenceStore().getBoolean("create_git_ignore")) {
                    IFile file = this.muleProject.getFile(GITIGNORE_FILENAME);
                    gitignoreResourceStream = this.getClass().getClassLoader().getResourceAsStream(GITIGNORE_MAVEN_TEMPLATE);
                    monitor.worked(20);
                    file.create(gitignoreResourceStream, false, monitor);
                    monitor.worked(50);
                    file.setDerived(false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)30));
                }
            }
            catch (CoreException e) {
                MuleUIPlugin.getDefault().logError("Could not create default gitignore file for the project", e);
                monitor.done();
                IOUtils.closeQuietly(gitignoreResourceStream);
            }
        }
        finally {
            monitor.done();
            IOUtils.closeQuietly(gitignoreResourceStream);
        }
    }

    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    @Override
    public void initializeDefaults() {
    }
}

