/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.DomainChangedEventHandler;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.EmptyProjectDescriptor;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.project.ChangeServerSelectionListener;
import org.mule.tooling.ui.project.MavenDependencyPickerDialog;
import org.mule.tooling.ui.project.extension.DomainSelectionChangeExtension;
import org.mule.tooling.ui.project.extension.DomainSelectionChangeListener;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class RuntimeConfigurationComponent {
    private IMuleProject muleProject;
    private ComboViewer runtimeCombo;
    private ComboViewer domainCombo;
    private Composite domainsComposite;
    private CLabel domainsStatus;
    private final ChangeDomainSelectionListener changeDomainSelectionListener = new ChangeDomainSelectionListener();
    private final GridDataFactory domainsCompositeVisibleDataFactory = GridDataFactory.fillDefaults().grab(true, false).span(2, 1);
    private final Composite rootComposite;

    public RuntimeConfigurationComponent(Composite parent) {
        this.rootComposite = parent;
    }

    public void loadFromMuleProject(IMuleProject muleProject) {
        boolean isApplicationWithDefaultDomain;
        this.muleProject = muleProject;
        boolean isMuleApplication = MuleProjectKind.APPLICATION.classifies(muleProject);
        boolean isDomainProject = MuleProjectKind.DOMAIN.classifies(muleProject);
        boolean bl = isApplicationWithDefaultDomain = isMuleApplication && ((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject)).hasDefaultDomain();
        if (isMuleApplication) {
            this.runtimeCombo.setInput((Object)MuleCorePlugin.getServerManager().getServerDefinitions());
        } else if (isDomainProject) {
            this.runtimeCombo.setInput((Object)CoreUtils.getDomainsCapableServers());
        }
        this.runtimeCombo.getCombo().setEnabled(isDomainProject || isApplicationWithDefaultDomain);
        String chosenRuntime = muleProject.getRuntimeId();
        IServerDefinition server = MuleCorePlugin.getServerManager().getServerDefinition(chosenRuntime);
        if (server != null) {
            StructuredSelection selection = new StructuredSelection((Object)server);
            this.runtimeCombo.setSelection((ISelection)selection);
            this.runtimeCombo.refresh();
        }
        if (isDomainProject) {
            GridDataFactory.swtDefaults().hint(0, 0).applyTo((Control)this.domainsComposite);
        } else if (isMuleApplication) {
            this.configureDomainsCombo((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject));
        }
        this.rootComposite.layout();
    }

    private void configureDomainsCombo(IMuleApplicationProject muleAppProject) {
        try {
            this.loadDomainsInput((IMuleProject)muleAppProject);
            this.domainsCompositeVisibleDataFactory.applyTo((Control)this.domainsComposite);
            this.setDomainSelection(muleAppProject);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem retrieving the available domain projects", (Throwable)e);
        }
    }

    private void setDomainSelection(IMuleApplicationProject muleAppProject) {
        StructuredSelection structuredSelection;
        if (muleAppProject.hasDefaultDomain()) {
            structuredSelection = new StructuredSelection((Object)DomainProjectInput.DEFAULT);
            this.refreshDomainsStatus(null);
        } else {
            IMuleDomain domain = muleAppProject.getDomain();
            structuredSelection = domain != null ? new StructuredSelection((Object)DomainProjectInput.create(domain)) : new StructuredSelection((Object)DomainProjectInput.DEFAULT);
            this.refreshDomainsStatus(domain);
        }
        this.domainCombo.removeSelectionChangedListener((ISelectionChangedListener)this.getDomainComboSelectionListener());
        this.domainCombo.setSelection((ISelection)structuredSelection);
        this.domainCombo.addSelectionChangedListener((ISelectionChangedListener)this.getDomainComboSelectionListener());
    }

    private void refreshDomainsStatus(IMuleDomain domain) {
        if (domain != null) {
            if (!domain.isValid()) {
                this.domainsStatus.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                this.domainsStatus.setText("The domain set " + DomainMavenDependencyComparator.toGavString((MavenDependency)domain.getMavenCoordinates()) + " could not be retrieved.");
                this.domainsStatus.setVisible(true);
            } else {
                List conflictingExtensions = DomainUtils.findConflictingExtensions((IMuleProject)this.muleProject, (IMuleDomain)domain).collect(Collectors.toList());
                if (!conflictingExtensions.isEmpty()) {
                    this.domainsStatus.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
                    this.domainsStatus.setText("Existing module conflicts with domain. Go to Problems view for more details.");
                    this.domainsStatus.setVisible(true);
                } else {
                    this.domainsStatus.setVisible(false);
                }
            }
        } else {
            this.domainsStatus.setVisible(false);
        }
    }

    public void createControl(Composite client) throws CoreException {
        GridLayout clientLayout = new GridLayout(2, false);
        client.setLayout((Layout)clientLayout);
        this.createServerSection(client);
        this.createDomainsSection(client);
    }

    public void createServerSection(Composite client) {
        List runtimes = MuleCorePlugin.getServerManager().getServerDefinitions();
        GridData data = new GridData(1, 0x1000000, false, false);
        data.widthHint = 120;
        Label rtLabel = new Label(client, 0);
        rtLabel.setText("Server Runtime:");
        rtLabel.setToolTipText("Choose a server runtime.");
        rtLabel.setLayoutData((Object)data);
        this.runtimeCombo = new ComboViewer(client, 76);
        this.runtimeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runtimeCombo.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider(){

            @Override
            public String getText(Object element) {
                Object text = super.getText(element);
                if (!RuntimeConfigurationComponent.this.runtimeCombo.getCombo().isEnabled()) {
                    text = (String)text + " (configured in domain)";
                }
                return text;
            }
        });
        this.runtimeCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.runtimeCombo.setInput((Object)runtimes);
        ChangeServerSelectionListener selectionChangeListener = new ChangeServerSelectionListener(this, client);
        this.runtimeCombo.addSelectionChangedListener((ISelectionChangedListener)selectionChangeListener);
    }

    public void createDomainsSection(final Composite client) throws CoreException {
        this.domainsComposite = new Composite(client, 0);
        GridData gridDataDomainLabel = new GridData(1, 0x1000000, false, false);
        gridDataDomainLabel.widthHint = 120;
        Label domainLabel = new Label(this.domainsComposite, 0);
        domainLabel.setText("Domain:");
        domainLabel.setToolTipText("Choose a parent domain project.");
        domainLabel.setLayoutData((Object)gridDataDomainLabel);
        this.domainCombo = new ComboViewer(this.domainsComposite, 76);
        this.domainCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.domainCombo.setLabelProvider((IBaseLabelProvider)new DomainLabelProvider());
        this.domainCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.domainCombo.addSelectionChangedListener((ISelectionChangedListener)this.getDomainComboSelectionListener());
        Link customDomain = new Link(this.domainsComposite, 0);
        customDomain.setText("<a>Custom...</a>");
        customDomain.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private final DomainChangedEventHandler domainChangedListener;
            {
                this.domainChangedListener = new DomainChangedEventHandler(){

                    public void onDomainChangedSuccessfully(IMuleApplicationProject applicationProject, IMuleDomain domain) {
                        if (applicationProject.equals((this).RuntimeConfigurationComponent.this.muleProject) && !composite.isDisposed()) {
                            try {
                                RuntimeConfigurationComponent.this.loadDomainsInput((IMuleProject)applicationProject);
                            }
                            catch (CoreException e) {
                                MuleCorePlugin.logError((String)"Could not load domain input", (Throwable)e);
                            }
                            (this).RuntimeConfigurationComponent.this.domainCombo.getCombo().setEnabled(true);
                            RuntimeConfigurationComponent.this.setDomainSelection(applicationProject);
                        }
                        MuleCorePlugin.getEventBus().unRegisterListener(CoreEventTypes.DOMAIN_CHANGED, (IEventHandler)domainChangedListener);
                    }

                    public void onDomainChangedFailed(IMuleApplicationProject applicationProject, MavenDependency domainDependency) {
                        if (applicationProject.equals((this).RuntimeConfigurationComponent.this.muleProject) && !composite.isDisposed()) {
                            try {
                                RuntimeConfigurationComponent.this.loadDomainsInput((IMuleProject)applicationProject);
                            }
                            catch (CoreException e) {
                                MuleCorePlugin.logError((String)("Could not set domain " + DomainMavenDependencyComparator.toGavString((MavenDependency)domainDependency)), (Throwable)e);
                            }
                            (this).RuntimeConfigurationComponent.this.domainCombo.getCombo().setEnabled(true);
                            RuntimeConfigurationComponent.this.setDomainSelection(applicationProject);
                        }
                        MuleCorePlugin.getEventBus().unRegisterListener(CoreEventTypes.DOMAIN_CHANGED, (IEventHandler)domainChangedListener);
                    }
                };
            }

            public void widgetSelected(SelectionEvent event) {
                MavenDependencyPickerDialog dialog = new MavenDependencyPickerDialog(client.getShell());
                dialog.setDefaultClassifier("mule-domain");
                dialog.setDefaultArtifact("domain");
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    IMuleApplicationProject muleAppProject;
                    MavenDependency dependency = DomainUtils.toDomainDependencyCoordinates((MavenDependency)dialog.getDependency());
                    final Optional<MavenDependency> optionalDomain = Optional.of(dependency);
                    if (DomainMavenDependencyComparator.correspondsTo(optionalDomain, (Optional)(muleAppProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(RuntimeConfigurationComponent.this.muleProject)).getDomainCoordinates())) {
                        return;
                    }
                    MuleCorePlugin.getEventBus().registerUIThreadListener(CoreEventTypes.DOMAIN_CHANGED, (IEventHandler)this.domainChangedListener);
                    Job resolveDomainJob = new Job("Resolving domain"){

                        public IStatus run(IProgressMonitor monitor) {
                            try {
                                muleAppProject.setDomain(optionalDomain, monitor);
                            }
                            catch (CoreException coreException) {
                                return new Status(4, "org.mule.tooling.core", "Error while resolving domain");
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    resolveDomainJob.setPriority(10);
                    RuntimeConfigurationComponent.this.domainCombo.getCombo().setEnabled(false);
                    RuntimeConfigurationComponent.this.domainsStatus.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                    RuntimeConfigurationComponent.this.domainsStatus.setText("Resolving domain depency " + DomainMavenDependencyComparator.toGavString((MavenDependency)dependency) + "...");
                    RuntimeConfigurationComponent.this.domainsStatus.setVisible(true);
                    resolveDomainJob.schedule();
                }
            }
        });
        this.domainsStatus = new CLabel(this.domainsComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.domainsStatus);
        this.domainsStatus.setVisible(false);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(this.domainsComposite);
        this.domainsCompositeVisibleDataFactory.applyTo((Control)this.domainsComposite);
    }

    public void loadDomainsInput(IMuleProject muleProject) throws CoreException {
        List<DomainProjectInput> domainsInput = this.getAvailableDomains();
        IMuleApplicationProject muleAppProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject);
        IMuleDomain domain = muleAppProject.getDomain();
        this.ensureDomainIsInInput(domain, domainsInput);
        this.domainCombo.setInput(domainsInput);
    }

    private void ensureDomainIsInInput(IMuleDomain domain, List<DomainProjectInput> domainsInput) {
        boolean domainExists;
        boolean bl = domainExists = domain == null || domain.isDefault() || domain != null && this.domainExists(domain.getMavenCoordinates(), domainsInput);
        if (!domainExists && domain != null) {
            domainsInput.add(DomainProjectInput.create(domain));
        }
    }

    private boolean domainExists(MavenDependency domainDependency, List<DomainProjectInput> domainsInput) {
        return domainsInput.stream().anyMatch(domainInput -> domainInput.getDomainCoordinates().map(coordinates -> DomainMavenDependencyComparator.correspondsTo((MavenDependency)coordinates, (MavenDependency)domainDependency)).orElse(false));
    }

    private List<DomainProjectInput> getAvailableDomains() throws CoreException {
        List domains = MuleRuntime.getMuleProjects((MuleProjectKind)MuleProjectKind.DOMAIN);
        ArrayList<DomainProjectInput> domainInput = new ArrayList<DomainProjectInput>(domains.size() + 1);
        domainInput.add(DomainProjectInput.DEFAULT);
        for (IMuleDomainProject domainProject : domains) {
            domainInput.add(DomainProjectInput.create((IMuleDomain)domainProject));
        }
        return domainInput;
    }

    private ChangeDomainSelectionListener getDomainComboSelectionListener() {
        return this.changeDomainSelectionListener;
    }

    public void commit() {
        StructuredSelection selection = (StructuredSelection)this.runtimeCombo.getSelection();
        IServerDefinition server = (IServerDefinition)selection.getFirstElement();
        try {
            this.muleProject.changeRuntime(server.getId());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem changing the runtime version for project " + this.muleProject.getName()), (Throwable)e);
        }
    }

    protected IMuleProject getMuleProject() {
        return this.muleProject;
    }

    protected IServerDefinition getSelectedServer() {
        return (IServerDefinition)this.runtimeCombo.getStructuredSelection().getFirstElement();
    }

    private final class ChangeDomainSelectionListener
    implements ISelectionChangedListener {
        private ChangeDomainSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IMuleDomain previousDomain;
            DomainProjectInput domainSelection;
            IMuleApplicationProject muleAppProject;
            block7: {
                muleAppProject = (IMuleApplicationProject)RuntimeConfigurationComponent.this.muleProject;
                domainSelection = (DomainProjectInput)RuntimeConfigurationComponent.this.domainCombo.getStructuredSelection().getFirstElement();
                previousDomain = muleAppProject.getDomain();
                if (domainSelection.getDomain() == null || domainSelection.getDomain() != null && !domainSelection.getDomain().equals(previousDomain)) {
                    try {
                        try {
                            muleAppProject.setDomain(domainSelection.getDomainCoordinates());
                            if (domainSelection.getDomainCoordinates().isPresent()) {
                                muleAppProject.changeRuntime(domainSelection.getServerDefinition().getId());
                            }
                        }
                        catch (CoreException e) {
                            MuleUIPlugin.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), e.getStatus());
                            RuntimeConfigurationComponent.this.loadFromMuleProject(RuntimeConfigurationComponent.this.muleProject);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        RuntimeConfigurationComponent.this.loadFromMuleProject(RuntimeConfigurationComponent.this.muleProject);
                        throw throwable;
                    }
                    RuntimeConfigurationComponent.this.loadFromMuleProject(RuntimeConfigurationComponent.this.muleProject);
                }
            }
            this.postDomainSelectionChanged(event, muleAppProject, previousDomain, domainSelection);
        }

        private void postDomainSelectionChanged(SelectionChangedEvent event, IMuleApplicationProject muleAppProject, IMuleDomain previousDomain, DomainProjectInput domainSelection) {
            List<DomainSelectionChangeListener> domainSelectionChangeListeners = this.getDomainSelectionChangeListeners();
            for (DomainSelectionChangeListener domainSelectionChangeListener : domainSelectionChangeListeners) {
                try {
                    domainSelectionChangeListener.domainSelectionChanged(event, muleAppProject, Optional.ofNullable(previousDomain), domainSelection.getDomainCoordinates(), Optional.ofNullable(domainSelection.getDomain()));
                }
                catch (Throwable e) {
                    MuleUIPlugin.getDefault().logError("Unexpected error executing domain selection changed listener: " + domainSelectionChangeListener.getClass().getName(), e);
                }
            }
        }

        private List<DomainSelectionChangeListener> getDomainSelectionChangeListeners() {
            List<DomainSelectionChangeExtension> extensions = DomainSelectionChangeExtension.getExtensions();
            ArrayList<DomainSelectionChangeListener> listeners = new ArrayList<DomainSelectionChangeListener>(extensions.size());
            for (DomainSelectionChangeExtension extension : extensions) {
                listeners.add(extension.getListener());
            }
            return listeners;
        }
    }

    private static class DomainLabelProvider
    extends LabelProvider {
        private DomainLabelProvider() {
        }

        public String getText(Object element) {
            return ((DomainProjectInput)element).getDomainName();
        }
    }

    private static class DomainProjectInput {
        private static final DomainProjectInput DEFAULT = new DomainProjectInput(new DefaultDomain());
        private final IMuleDomain domain;

        public static DomainProjectInput create(IMuleDomain domainProject) {
            return new DomainProjectInput(domainProject);
        }

        private DomainProjectInput(IMuleDomain domain) {
            this.domain = domain;
        }

        public IMuleDomain getDomain() {
            return this.domain;
        }

        public Optional<MavenDependency> getDomainCoordinates() {
            return Optional.ofNullable(this.domain.getMavenCoordinates()).map(DomainUtils::toDomainDependencyCoordinates);
        }

        public IServerDefinition getServerDefinition() {
            return this.domain.getServerDefinition();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DomainProjectInput other = (DomainProjectInput)obj;
            return !(this.domain == null ? other.domain != null : !this.domain.equals(other.domain));
        }

        public String getDomainName() {
            return this.domain.getDomainName();
        }

        private static class DefaultDomain
        implements IMuleDomain {
            private DefaultDomain() {
            }

            public List<IMuleApplicationProject> getChildProjects() {
                return null;
            }

            public String getDomainName() {
                return "default";
            }

            public MavenDependency getMavenCoordinates() {
                return null;
            }

            public IServerDefinition getServerDefinition() {
                return CoreUtils.getDefaultServer();
            }

            public List<MuleExtension> getMuleExtensions() {
                return Collections.emptyList();
            }

            public IMuleProjectModel getMuleProjectModel() {
                return EmptyProjectDescriptor.instance();
            }

            public boolean isExternal() {
                return false;
            }

            public boolean isValid() {
                return true;
            }
        }
    }
}

