/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;

public class ProjectDocumentationComponent {
    private IMuleProject muleProject;
    private Text txtDescription;
    private String originalDescription;

    public void loadFromMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
        if (muleProject != null) {
            this.originalDescription = muleProject.getDescription();
            this.txtDescription.setText(muleProject.getDescription() != null ? muleProject.getDescription() : "");
        }
    }

    public void createContent(Composite client) {
        GridLayout clientLayout = new GridLayout(1, false);
        client.setLayout((Layout)clientLayout);
        this.createDesriptionText(client);
    }

    private void createDesriptionText(Composite client) {
        Label descLabel = new Label(client, 0);
        descLabel.setText("Project description:");
        descLabel.setLayoutData((Object)new GridData(2));
        this.txtDescription = new Text(client, 2114);
        this.txtDescription.setTextLimit(1000);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        gd.grabExcessHorizontalSpace = true;
        this.txtDescription.setLayoutData((Object)gd);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectDocumentationComponent.this.txtDescription.getText().equals(ProjectDocumentationComponent.this.muleProject.getDescription());
            }
        });
    }

    public void commit() {
        if (StringUtils.isNotBlank((String)this.txtDescription.getText()) && !this.txtDescription.getText().equals(this.originalDescription)) {
            this.muleProject.setDescription(this.txtDescription.getText());
        }
    }
}

